/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import org.apache.nifi.authorization.ShellCommandsProvider;

class RemoteShellCommands
implements ShellCommandsProvider {
    private static final String remoteCommand = "ssh -o 'StrictHostKeyChecking no' -o 'PasswordAuthentication no' -o \"RemoteCommand %s\" -i %s -p %s -l root %s";
    private ShellCommandsProvider innerProvider;
    private String privateKeyPath;
    private String remoteHost;
    private Integer remotePort;

    private RemoteShellCommands() {
    }

    public static ShellCommandsProvider wrapOtherProvider(ShellCommandsProvider otherProvider, String keyPath, String host, Integer port) {
        RemoteShellCommands remote = new RemoteShellCommands();
        remote.innerProvider = otherProvider;
        remote.privateKeyPath = keyPath;
        remote.remoteHost = host;
        remote.remotePort = port;
        return remote;
    }

    @Override
    public String getUsersList() {
        return String.format(remoteCommand, this.innerProvider.getUsersList(), this.privateKeyPath, this.remotePort, this.remoteHost);
    }

    @Override
    public String getGroupsList() {
        return String.format(remoteCommand, this.innerProvider.getGroupsList(), this.privateKeyPath, this.remotePort, this.remoteHost);
    }

    @Override
    public String getGroupMembers(String groupName) {
        return String.format(remoteCommand, this.innerProvider.getGroupMembers(groupName), this.privateKeyPath, this.remotePort, this.remoteHost);
    }

    @Override
    public String getUserById(String userId) {
        return String.format(remoteCommand, this.innerProvider.getUserById(userId), this.privateKeyPath, this.remotePort, this.remoteHost);
    }

    @Override
    public String getUserByName(String userName) {
        return String.format(remoteCommand, this.innerProvider.getUserByName(userName), this.privateKeyPath, this.remotePort, this.remoteHost);
    }

    @Override
    public String getGroupById(String groupId) {
        return String.format(remoteCommand, this.innerProvider.getGroupById(groupId), this.privateKeyPath, this.remotePort, this.remoteHost);
    }

    @Override
    public String getSystemCheck() {
        return String.format(remoteCommand, this.innerProvider.getSystemCheck(), this.privateKeyPath, this.remotePort, this.remoteHost);
    }
}

