/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import org.apache.nifi.authorization.ShellCommandsProvider;

class OsxShellCommands
implements ShellCommandsProvider {
    OsxShellCommands() {
    }

    @Override
    public String getUsersList() {
        return "dscl . -readall /Users UniqueID PrimaryGroupID | awk 'BEGIN { OFS = \":\"; ORS=\"\\n\"; i=0;} /RecordName: / {name = $2;i = 0;}/PrimaryGroupID: / {gid = $2;} /^ / {if (i == 0) { i++; name = $1;}} /UniqueID: / {uid = $2;print name, uid, gid;}' | grep -v ^_";
    }

    @Override
    public String getGroupsList() {
        return "dscl . -list /Groups PrimaryGroupID  | grep -v '^_' | sed 's/ \\{1,\\}/:/g'";
    }

    @Override
    public String getGroupMembers(String groupName) {
        return String.format("dscl . -read /Groups/%s GroupMembership | cut -f 2- -d ' ' | sed 's/\\ /,/g'", groupName);
    }

    @Override
    public String getUserById(String userId) {
        return String.format("id -P %s | cut -f 1,3,4 -d ':'", userId);
    }

    @Override
    public String getUserByName(String userName) {
        return this.getUserById(userName);
    }

    @Override
    public String getGroupById(String groupId) {
        return String.format(" dscl . -read /Groups/`dscl . -search /Groups gid %s | head -n 1 | cut -f 1` RecordName PrimaryGroupID | awk 'BEGIN { OFS = \":\"; ORS=\"\\n\"; i=0;} /RecordName: / {name = $2;i = 1;}/PrimaryGroupID: / {gid = $2;}; {if (i==1) {print name,gid,\"\"}}'", groupId);
    }

    @Override
    public String getSystemCheck() {
        return "which dscl";
    }
}

