/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.InvokeScriptedProcessor;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.script.ScriptingComponentHelper;
import org.apache.nifi.script.ScriptingComponentUtils;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.SearchResult;
import org.apache.nifi.search.Searchable;

@Tags(value={"script", "execute", "groovy", "clojure"})
@CapabilityDescription(value="Experimental - Executes a script given the flow file and a process session.  The script is responsible for handling the incoming flow file (transfer to SUCCESS or remove, e.g.) as well as any flow files created by the script. If the handling is incomplete or incorrect, the session will be rolled back. Experimental: Impact of sustained usage not yet verified.")
@SupportsSensitiveDynamicProperties
@DynamicProperty(name="Script Engine Binding property", value="Binding property value passed to Script Runner", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@Stateful(scopes={Scope.LOCAL, Scope.CLUSTER}, description="Scripts can store and retrieve state using the State Management APIs. Consult the State Manager section of the Developer's Guide for more details.")
@SeeAlso(value={InvokeScriptedProcessor.class})
public class ExecuteScript
extends AbstractSessionFactoryProcessor
implements Searchable {
    public static final Relationship REL_SUCCESS = ScriptingComponentUtils.REL_SUCCESS;
    public static final Relationship REL_FAILURE = ScriptingComponentUtils.REL_FAILURE;
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private volatile String scriptToRun = null;
    volatile ScriptingComponentHelper scriptingComponentHelper = new ScriptingComponentHelper();

    public void migrateProperties(PropertyConfiguration config) {
        ScriptingComponentHelper.migrateProperties(config);
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources(false);
            }
        }
        return Collections.unmodifiableList(this.scriptingComponentHelper.getDescriptors());
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return this.scriptingComponentHelper.customValidate(validationContext);
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        block7: {
            this.scriptingComponentHelper.setupVariables((PropertyContext)context);
            this.scriptToRun = this.scriptingComponentHelper.getScriptBody();
            try {
                if (this.scriptToRun != null || this.scriptingComponentHelper.getScriptPath() == null) break block7;
                try (FileInputStream scriptStream = new FileInputStream(this.scriptingComponentHelper.getScriptPath());){
                    this.scriptToRun = IOUtils.toString((InputStream)scriptStream, (Charset)Charset.defaultCharset());
                }
            }
            catch (IOException ioe) {
                throw new ProcessException((Throwable)ioe);
            }
        }
        int maxTasks = context.getMaxConcurrentTasks();
        this.scriptingComponentHelper.setupScriptRunners(maxTasks, this.scriptToRun, this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources(false);
            }
        }
        ScriptRunner scriptRunner = (ScriptRunner)this.scriptingComponentHelper.scriptRunnerQ.poll();
        ComponentLog log = this.getLogger();
        if (scriptRunner == null) {
            return;
        }
        ProcessSession session = sessionFactory.createSession();
        try {
            ScriptEngine scriptEngine = scriptRunner.getScriptEngine();
            try {
                Bindings bindings = scriptEngine.getBindings(100);
                if (bindings == null) {
                    bindings = new SimpleBindings();
                }
                bindings.put("session", (Object)session);
                bindings.put("context", (Object)context);
                bindings.put("log", (Object)log);
                bindings.put("REL_SUCCESS", (Object)REL_SUCCESS);
                bindings.put("REL_FAILURE", (Object)REL_FAILURE);
                for (Map.Entry property : context.getProperties().entrySet()) {
                    if (!((PropertyDescriptor)property.getKey()).isDynamic() || property.getValue() == null) continue;
                    bindings.put(((PropertyDescriptor)property.getKey()).getName(), (Object)context.getProperty((PropertyDescriptor)property.getKey()));
                }
                scriptRunner.run(bindings);
                session.commitAsync();
                this.scriptingComponentHelper.scriptRunnerQ.offer(scriptRunner);
            }
            catch (Throwable t) {
                this.scriptingComponentHelper.setupScriptRunners(false, 1, this.scriptToRun, this.getLogger());
                context.yield();
                throw new ProcessException(t);
            }
        }
        catch (Throwable t) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Script as executed by NiFi with preloads {}", new Object[]{scriptRunner.getScript()});
            }
            this.getLogger().error("{} failed to process due to {}; rolling back session", new Object[]{this, t});
            session.rollback(true);
            throw t;
        }
    }

    @OnStopped
    public void stop() {
        this.scriptingComponentHelper.stop();
    }

    @OnAdded
    public void added() {
        this.scriptingComponentHelper.createResources(false);
    }

    public Collection<SearchResult> search(SearchContext context) {
        return ScriptingComponentUtils.search(context, this.getLogger());
    }
}

