/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.services;

import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.schemaregistry.services.MessageName;

public class StandardMessageName
implements MessageName {
    private final Optional<String> namespace;
    private final String name;

    public StandardMessageName(Optional<String> namespace, String name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.namespace = namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getNamespace() {
        return this.namespace;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardMessageName)) {
            return false;
        }
        StandardMessageName that = (StandardMessageName)o;
        return this.name.equals(that.name) && this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.namespace.hashCode();
        return result;
    }

    public String toString() {
        return String.format("StandardMessageName{name='%s', namespace='%s'}", this.name, this.namespace);
    }
}

