/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.transfer;

import java.util.Map;
import java.util.Optional;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.fileresource.service.api.FileResourceService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.transfer.ResourceTransferProperties;
import org.apache.nifi.processors.transfer.ResourceTransferSource;

public final class ResourceTransferUtils {
    private ResourceTransferUtils() {
    }

    public static Optional<FileResource> getFileResource(ResourceTransferSource resourceTransferSource, ProcessContext context, Map<String, String> attributes) {
        Optional<FileResource> resource;
        if (resourceTransferSource == ResourceTransferSource.FILE_RESOURCE_SERVICE) {
            PropertyValue property = context.getProperty(ResourceTransferProperties.FILE_RESOURCE_SERVICE);
            if (property == null || !property.isSet()) {
                throw new ProcessException("File Resource Service required but not configured");
            }
            FileResourceService fileResourceService = (FileResourceService)property.asControllerService(FileResourceService.class);
            FileResource fileResource = fileResourceService.getFileResource(attributes);
            resource = Optional.ofNullable(fileResource);
        } else {
            resource = Optional.empty();
        }
        return resource;
    }
}

