/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.questdb.mapping.RequestMapping;

final class SimpleRequestMapping<T>
implements RequestMapping<T> {
    private final Supplier<T> factory;
    private final List<Pair<Class<?>, BiConsumer<T, Object>>> fieldMappings;

    SimpleRequestMapping(Supplier<T> factory, List<Pair<Class<?>, BiConsumer<T, Object>>> fieldMappings) {
        this.factory = factory;
        this.fieldMappings = new ArrayList(fieldMappings);
    }

    @Override
    public T getNewInstance() {
        return this.factory.get();
    }

    @Override
    public int getNumberOfFields() {
        return this.fieldMappings.size();
    }

    @Override
    public Class<?> getFieldType(int position) {
        return (Class)this.fieldMappings.get(position).getKey();
    }

    @Override
    public BiConsumer<T, Object> getMapping(int position) {
        return (BiConsumer)this.fieldMappings.get(position).getRight();
    }
}

