/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.rollover;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.nifi.questdb.Client;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.QueryRowContext;
import org.apache.nifi.questdb.rollover.RolloverStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeleteOldRolloverStrategy
implements RolloverStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteOldRolloverStrategy.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private static final String DELETION_QUERY = "ALTER TABLE %s DROP PARTITION LIST '%s'";
    private static final String PARTITION_SELECTION_QUERY = "SELECT DISTINCT * FROM (SELECT (to_str(captured, 'yyyy-MM-dd')) AS partitionName FROM %s)";
    private final Supplier<ZonedDateTime> timeSource;
    private final int daysToKeep;

    DeleteOldRolloverStrategy(Supplier<ZonedDateTime> timeSource, int daysToKeep) {
        this.timeSource = timeSource;
        this.daysToKeep = daysToKeep;
    }

    @Override
    public void rollOver(Client client, String tableName) {
        try {
            List<String> partitions = this.getPartitions(client, tableName);
            String oldestPartitionToKeep = this.getOldestPartitionToKeep();
            for (int i = 0; i < partitions.size() - 1; ++i) {
                String partition = partitions.get(i);
                if (oldestPartitionToKeep.compareTo(partition) <= 0) continue;
                try {
                    client.execute(String.format(DELETION_QUERY, tableName, partition));
                    LOGGER.debug("Dropping partition [{}] of table [{}] was successful", (Object)partition, (Object)tableName);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Dropping partition [{}] of table [{}] failed", new Object[]{partition, tableName, e});
                }
            }
        }
        catch (Exception e2) {
            LOGGER.error("Rollover failed for table [{}]", (Object)tableName, (Object)e2);
        }
    }

    private List<String> getPartitions(Client client, CharSequence tableName) throws Exception {
        return client.query(String.format(PARTITION_SELECTION_QUERY, tableName), new PartitionQueryResultProcessor());
    }

    private String getOldestPartitionToKeep() {
        ZonedDateTime now = this.timeSource.get();
        ZonedDateTime utc = now.minusDays(this.daysToKeep).withZoneSameInstant(ZoneOffset.UTC);
        return utc.format(DATE_FORMATTER);
    }

    private static class PartitionQueryResultProcessor
    implements QueryResultProcessor<List<String>> {
        List<String> result = new LinkedList<String>();

        private PartitionQueryResultProcessor() {
        }

        @Override
        public void processRow(QueryRowContext context) {
            this.result.add(context.getString(0));
        }

        @Override
        public List<String> getResult() {
            Collections.sort(this.result);
            return this.result;
        }
    }
}

