/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.logging;

import java.util.Map;
import org.apache.nifi.logging.LogLevel;

public enum PythonLogLevel {
    NOTSET(0),
    DEBUG(10),
    INFO(20),
    WARNING(30),
    ERROR(40),
    CRITICAL(50);

    private static final Map<LogLevel, PythonLogLevel> FRAMEWORK_LEVELS;
    private final int level;

    private PythonLogLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static PythonLogLevel valueOf(LogLevel logLevel) {
        return FRAMEWORK_LEVELS.getOrDefault(logLevel, WARNING);
    }

    static {
        FRAMEWORK_LEVELS = Map.of(LogLevel.NONE, NOTSET, LogLevel.DEBUG, DEBUG, LogLevel.INFO, INFO, LogLevel.WARN, WARNING, LogLevel.ERROR, ERROR, LogLevel.FATAL, CRITICAL);
    }
}

