/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.py4j.client.CommandBuilder;
import org.apache.nifi.py4j.client.JavaObjectBindings;
import org.apache.nifi.py4j.client.NiFiPythonGateway;
import org.apache.nifi.python.processor.Idempotent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.Gateway;
import py4j.Protocol;
import py4j.Py4JException;
import py4j.reflection.MethodInvoker;
import py4j.reflection.TypeConverter;

public class PythonProxyInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(PythonProxyInvocationHandler.class);
    private final String objectId;
    private final NiFiPythonGateway gateway;
    private final JavaObjectBindings bindings;
    private final String gcCommand;
    private final ConcurrentMap<Method, Object> cachedValues = new ConcurrentHashMap<Method, Object>();

    public PythonProxyInvocationHandler(NiFiPythonGateway gateway, String objectId) {
        this.objectId = objectId;
        this.gateway = gateway;
        this.bindings = gateway.getObjectBindings();
        this.gcCommand = "g\n" + objectId + "\ne\n";
    }

    public void free() {
        if (this.objectId != "t") {
            logger.debug("Issuing GC command to python for proxy id {}", (Object)this.objectId);
            this.gateway.getCallbackClient().sendCommand(this.gcCommand, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object cachedValue;
        boolean idempotent;
        if (args == null && method.getName().equals("toString")) {
            return "PythonProxy[targetObjectId=" + this.objectId + "]";
        }
        boolean bl = idempotent = (args == null || args.length == 0) && method.getAnnotation(Idempotent.class) != null;
        if (idempotent && (cachedValue = this.cachedValues.get(method)) != null) {
            return cachedValue;
        }
        CommandBuilder commandBuilder = new CommandBuilder(this.bindings, this.objectId, method.getName());
        String command = commandBuilder.buildCommand(args);
        if (logger.isDebugEnabled()) {
            List<Object> argList = args == null ? Collections.emptyList() : Arrays.asList(args);
            logger.debug("Invoking {} on {} with args {} using command {}", new Object[]{method, proxy, argList, command});
        }
        NiFiPythonGateway.InvocationBindings invocationBindings = this.gateway.beginInvocation(this.objectId, method, args);
        try {
            String response = this.gateway.getCallbackClient().sendCommand(command);
            Object output = Protocol.getReturnValue((String)response, (Gateway)this.gateway);
            Object result = this.convertOutput(method, output);
            if (idempotent) {
                this.cachedValues.putIfAbsent(method, result);
            }
            Object object = result;
            return object;
        }
        finally {
            if (invocationBindings.isUnbind()) {
                commandBuilder.getBoundIds().forEach(this.bindings::unbind);
                commandBuilder.getBoundIds().forEach(i -> logger.debug("For method invocation {} unbound {} (from command builder)", (Object)method.getName(), i));
            } else {
                commandBuilder.getBoundIds().forEach(i -> logger.debug("For method invocation {} will not unbind {} (from command builder) because arguments of this method are not to be unbound", (Object)method.getName(), i));
            }
            this.gateway.endInvocation(invocationBindings);
        }
    }

    private Object convertOutput(Method method, Object output) {
        Class<?> returnType = method.getReturnType();
        if (output == null || returnType.equals(Void.TYPE)) {
            return output;
        }
        ArrayList converters = new ArrayList();
        Class[] parameters = new Class[]{returnType};
        Class<?> outputType = output.getClass();
        Class[] arguments = new Class[]{outputType};
        int cost = MethodInvoker.buildConverters(converters, (Class[])parameters, (Class[])arguments);
        if (cost == -1) {
            throw new Py4JException("Incompatible output type. Expected: " + returnType.getName() + " Actual: " + outputType.getName());
        }
        return ((TypeConverter)converters.getFirst()).convert(output);
    }
}

