/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.JVMView;

public class JavaObjectBindings {
    private static final Logger logger = LoggerFactory.getLogger(JavaObjectBindings.class);
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final Map<String, Object> bindings = new HashMap<String, Object>();
    private final Map<String, Integer> bindingCounts = new HashMap<String, Integer>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public JavaObjectBindings() {
        this.bind("j", new JVMView("default", "j"), 1);
    }

    public String bind(Object object, int count) {
        String id = "o" + this.idGenerator.getAndIncrement();
        return this.bind(id, object, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bind(String objectId, Object object, int count) {
        if (count == 0) {
            logger.debug("Will not bind {} to ID {} because count is 0", object, (Object)objectId);
            return objectId;
        }
        this.writeLock.lock();
        try {
            this.bindings.put(objectId, object);
            this.bindingCounts.put(objectId, count);
        }
        finally {
            this.writeLock.unlock();
        }
        logger.debug("Bound {} to ID {} with count {}", new Object[]{object, objectId, count});
        return objectId;
    }

    public Object getBoundObject(String objectId) {
        this.readLock.lock();
        try {
            Object object = this.bindings.get(objectId);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unbind(String objectId) {
        this.writeLock.lock();
        try {
            int updatedValue;
            Integer currentValue = this.bindingCounts.remove(objectId);
            int n = updatedValue = currentValue == null ? 0 : currentValue - 1;
            if (updatedValue < 1) {
                Object unbound = this.bindings.remove(objectId);
                logger.debug("Unbound {} from ID {}", unbound, (Object)objectId);
                Object object = unbound;
                return object;
            }
            this.bindingCounts.put(objectId, updatedValue);
            logger.debug("Decremented binding count for ID {} to {}", (Object)objectId, (Object)updatedValue);
            Object object = this.bindings.get(objectId);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Map<String, Integer> getCountsPerClass() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        this.readLock.lock();
        try {
            this.bindings.values().forEach(object -> {
                String className = object == null ? "<null>" : object.getClass().getName();
                counts.merge(className, 1, Integer::sum);
            });
        }
        finally {
            this.readLock.unlock();
        }
        return counts;
    }
}

