/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Relationship;

public class RoutingResult {
    private final Map<Relationship, List<FlowFile>> routedFlowFiles = new HashMap<Relationship, List<FlowFile>>();

    public void routeTo(FlowFile flowFile, Relationship relationship) {
        this.routedFlowFiles.computeIfAbsent(relationship, r -> new ArrayList()).add(flowFile);
    }

    public void routeTo(List<FlowFile> flowFiles, Relationship relationship) {
        this.routedFlowFiles.computeIfAbsent(relationship, r -> new ArrayList()).addAll(flowFiles);
    }

    public void merge(RoutingResult r) {
        r.getRoutedFlowFiles().forEach((relationship, routedFlowFiles) -> this.routeTo((List<FlowFile>)routedFlowFiles, (Relationship)relationship));
    }

    public Map<Relationship, List<FlowFile>> getRoutedFlowFiles() {
        return this.routedFlowFiles;
    }

    public boolean contains(Relationship relationship) {
        return this.routedFlowFiles.containsKey(relationship) && !this.routedFlowFiles.get(relationship).isEmpty();
    }
}

