/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.protobuf;

import com.squareup.wire.schema.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.MessageName;
import org.apache.nifi.schemaregistry.services.MessageNameResolver;
import org.apache.nifi.schemaregistry.services.SchemaDefinition;
import org.apache.nifi.schemaregistry.services.SchemaReferenceReader;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.schemaregistry.services.StandardMessageNameFactory;
import org.apache.nifi.schemaregistry.services.StandardSchemaDefinition;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.services.protobuf.ProtobufRecordReader;
import org.apache.nifi.services.protobuf.ProtobufSchemaCompiler;
import org.apache.nifi.services.protobuf.SchemaCompilationException;
import org.apache.nifi.services.protobuf.schema.ProtoSchemaParser;

@Tags(value={"protobuf", "record", "reader", "parser"})
@CapabilityDescription(value="Parses Protocol Buffers messages from binary format into NiFi Records. Supports multiple schema access strategies including inline schema text, schema registry lookup, and schema reference readers.\nProtobuf reader needs to know the Proto schema message name in order to deserialize the binary payload correctly. The name of this message can be determined statically using 'Message Name' property, or dynamically, using a Message Name Resolver service.")
public class StandardProtobufReader
extends SchemaRegistryService
implements RecordReaderFactory {
    public static final PropertyDescriptor MESSAGE_NAME_RESOLUTION_STRATEGY = new PropertyDescriptor.Builder().name("Message Name Resolution Strategy").description("Strategy for determining the Protocol Buffers message name for processing").required(true).allowableValues(new DescribedValue[]{MessageNameResolverStrategy.MESSAGE_NAME_PROPERTY, MessageNameResolverStrategy.MESSAGE_NAME_RESOLVER}).defaultValue((DescribedValue)MessageNameResolverStrategy.MESSAGE_NAME_PROPERTY).build();
    public static final PropertyDescriptor MESSAGE_NAME = new PropertyDescriptor.Builder().name("Message Name").description("Fully qualified name of the Protocol Buffers message including its package (eg. mypackage.MyMessage).").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(MESSAGE_NAME_RESOLUTION_STRATEGY, (DescribedValue)MessageNameResolverStrategy.MESSAGE_NAME_PROPERTY, new DescribedValue[0]).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MESSAGE_NAME_RESOLVER = new PropertyDescriptor.Builder().name("Message Name Resolver").description("Service that dynamically resolves Protocol Buffer message names from FlowFile content or attributes").required(true).identifiesControllerService(MessageNameResolver.class).dependsOn(MESSAGE_NAME_RESOLUTION_STRATEGY, (DescribedValue)MessageNameResolverStrategy.MESSAGE_NAME_RESOLVER, new DescribedValue[0]).build();
    private static final PropertyDescriptor PROTOBUF_SCHEMA_TEXT = new PropertyDescriptor.Builder().fromPropertyDescriptor(SchemaAccessUtils.SCHEMA_TEXT).required(true).clearValidators().addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${proto.schema}").description("The text of a Proto 3 formatted Schema").build();
    private static final String PROTO_EXTENSION = ".proto";
    private volatile ProtobufSchemaCompiler schemaCompiler;
    private volatile MessageNameResolver messageNameResolver;
    private volatile SchemaReferenceReader schemaReferenceReader;
    private volatile SchemaRegistry schemaRegistry;
    private volatile String schemaAccessStrategyValue;
    private volatile PropertyValue schemaText;
    private volatile PropertyValue schemaName;
    private volatile PropertyValue schemaBranchName;
    private volatile PropertyValue schemaVersion;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        super.storeSchemaAccessStrategy(context);
        this.setupMessageNameResolver(context);
        this.schemaAccessStrategyValue = context.getProperty(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY).getValue();
        this.schemaReferenceReader = (SchemaReferenceReader)context.getProperty(SchemaAccessUtils.SCHEMA_REFERENCE_READER).asControllerService(SchemaReferenceReader.class);
        this.schemaRegistry = (SchemaRegistry)context.getProperty(SchemaAccessUtils.SCHEMA_REGISTRY).asControllerService(SchemaRegistry.class);
        this.schemaName = context.getProperty(SchemaAccessUtils.SCHEMA_NAME);
        this.schemaText = context.getProperty(SchemaAccessUtils.SCHEMA_TEXT);
        this.schemaBranchName = context.getProperty(SchemaAccessUtils.SCHEMA_BRANCH_NAME);
        this.schemaVersion = context.getProperty(SchemaAccessUtils.SCHEMA_VERSION);
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws IOException, SchemaNotFoundException {
        if (SchemaAccessUtils.SCHEMA_TEXT_PROPERTY.getValue().equals(this.schemaAccessStrategyValue)) {
            SchemaDefinition schemaDefinition = this.createSchemaDefinitionFromText(variables);
            return this.createProtobufRecordReader(variables, in, schemaDefinition);
        }
        if (SchemaAccessUtils.SCHEMA_NAME_PROPERTY.getValue().equals(this.schemaAccessStrategyValue)) {
            SchemaDefinition schemaDefinition = this.createSchemaDefinitionFromRegistry(variables);
            return this.createProtobufRecordReader(variables, in, schemaDefinition);
        }
        if (SchemaAccessUtils.SCHEMA_REFERENCE_READER_PROPERTY.getValue().equals(this.schemaAccessStrategyValue)) {
            SchemaIdentifier schemaIdentifier = this.schemaReferenceReader.getSchemaIdentifier(variables, in);
            SchemaDefinition schemaDefinition = this.schemaRegistry.retrieveSchemaDefinition(schemaIdentifier);
            logger.debug("Using message name for schema identifier: {}", new Object[]{schemaDefinition.getIdentifier()});
            return this.createProtobufRecordReader(variables, in, schemaDefinition);
        }
        throw new SchemaNotFoundException("Unsupported schema access strategy: " + this.schemaAccessStrategyValue);
    }

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        super.init(config);
        this.schemaCompiler = new ProtobufSchemaCompiler(this.getIdentifier(), this.getLogger());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(MESSAGE_NAME_RESOLUTION_STRATEGY);
        properties.add(MESSAGE_NAME_RESOLVER);
        properties.add(MESSAGE_NAME);
        return properties;
    }

    protected PropertyDescriptor buildSchemaTextProperty() {
        return PROTOBUF_SCHEMA_TEXT;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String schemaAccessStrategyValue = validationContext.getProperty(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY).getValue();
        if (SchemaAccessUtils.SCHEMA_TEXT_PROPERTY.getValue().equals(schemaAccessStrategyValue)) {
            PropertyValue schemaTextProperty = validationContext.getProperty(SchemaAccessUtils.SCHEMA_TEXT);
            String schemaTextValue = schemaTextProperty.getValue();
            if (validationContext.isExpressionLanguagePresent(schemaTextValue)) {
                return results;
            }
            if (schemaTextValue == null || schemaTextValue.isBlank()) {
                results.add(new ValidationResult.Builder().subject(SchemaAccessUtils.SCHEMA_TEXT.getDisplayName()).input(schemaTextValue).valid(false).explanation("Schema Text value is missing").build());
                return results;
            }
            try {
                String hash = this.sha256Hex(schemaTextValue);
                SchemaIdentifier schemaIdentifier = SchemaIdentifier.builder().name(hash + PROTO_EXTENSION).build();
                Schema compiledSchema = this.validateSchemaCompiles(schemaIdentifier, schemaTextValue);
                String messageNameStrategy = validationContext.getProperty(MESSAGE_NAME_RESOLUTION_STRATEGY).getValue();
                if (MessageNameResolverStrategy.MESSAGE_NAME_PROPERTY.getValue().equals(messageNameStrategy)) {
                    PropertyValue messageNameProperty = validationContext.getProperty(MESSAGE_NAME);
                    String messageNameValue = messageNameProperty.getValue();
                    if (validationContext.isExpressionLanguageSupported(MESSAGE_NAME.getName()) && validationContext.isExpressionLanguagePresent(messageNameValue)) {
                        return results;
                    }
                    if (messageNameValue != null && !messageNameValue.isBlank() && compiledSchema.getType(messageNameValue) == null) {
                        results.add(new ValidationResult.Builder().subject(MESSAGE_NAME.getDisplayName()).input(messageNameValue).valid(false).explanation(String.format("Message name '%s' cannot be found in the provided protobuf schema", messageNameValue)).build());
                    }
                }
            }
            catch (SchemaCompilationException e) {
                results.add(new ValidationResult.Builder().subject(SchemaAccessUtils.SCHEMA_TEXT.getDisplayName()).input(schemaTextValue).valid(false).explanation("Invalid protobuf schema format: " + e.getMessage()).build());
            }
        }
        return results;
    }

    private Schema validateSchemaCompiles(SchemaIdentifier schemaIdentifier, String schemaTextValue) {
        StandardSchemaDefinition schemaDefinition = new StandardSchemaDefinition(schemaIdentifier, schemaTextValue, SchemaDefinition.SchemaType.PROTOBUF);
        return this.schemaCompiler.compileOrGetFromCache((SchemaDefinition)schemaDefinition);
    }

    private RecordReader createProtobufRecordReader(Map<String, String> variables, InputStream in, SchemaDefinition schemaDefinition) throws IOException {
        Schema schema = this.schemaCompiler.compileOrGetFromCache(schemaDefinition);
        ProtoSchemaParser schemaParser = new ProtoSchemaParser(schema);
        MessageName messageName = this.messageNameResolver.getMessageName(variables, schemaDefinition, in);
        RecordSchema recordSchema = schemaParser.createSchema(messageName.getFullyQualifiedName());
        return new ProtobufRecordReader(schema, messageName.getFullyQualifiedName(), in, recordSchema);
    }

    private void setupMessageNameResolver(ConfigurationContext context) {
        MessageNameResolverStrategy messageNameResolverStrategy = (MessageNameResolverStrategy)context.getProperty(MESSAGE_NAME_RESOLUTION_STRATEGY).asAllowableValue(MessageNameResolverStrategy.class);
        this.messageNameResolver = switch (messageNameResolverStrategy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new PropertyMessageNameResolver((PropertyContext)context);
            case 1 -> (MessageNameResolver)context.getProperty(MESSAGE_NAME_RESOLVER).asControllerService(MessageNameResolver.class);
        };
    }

    private SchemaDefinition createSchemaDefinitionFromText(Map<String, String> variables) throws SchemaNotFoundException {
        String schemaTextString = this.schemaText.evaluateAttributeExpressions(variables).getValue();
        this.validateSchemaText(schemaTextString);
        String hash = this.sha256Hex(schemaTextString);
        SchemaIdentifier schemaIdentifier = SchemaIdentifier.builder().name(hash + PROTO_EXTENSION).build();
        return new StandardSchemaDefinition(schemaIdentifier, schemaTextString, SchemaDefinition.SchemaType.PROTOBUF);
    }

    private String sha256Hex(String input) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
        return HexFormat.of().formatHex(hash);
    }

    private SchemaDefinition createSchemaDefinitionFromRegistry(Map<String, String> variables) throws SchemaNotFoundException, IOException {
        String schemaNameValue = this.schemaName.evaluateAttributeExpressions(variables).getValue();
        this.validateSchemaName(schemaNameValue);
        String schemaBranchNameValue = this.schemaBranchName.evaluateAttributeExpressions(variables).getValue();
        String schemaVersionValue = this.schemaVersion.evaluateAttributeExpressions(variables).getValue();
        SchemaIdentifier schemaIdentifier = this.buildSchemaIdentifier(schemaNameValue, schemaBranchNameValue, schemaVersionValue);
        return this.schemaRegistry.retrieveSchemaDefinition(schemaIdentifier);
    }

    private SchemaIdentifier buildSchemaIdentifier(String schemaNameValue, String schemaBranchNameValue, String schemaVersionValue) throws SchemaNotFoundException {
        SchemaIdentifier.Builder identifierBuilder = SchemaIdentifier.builder().name(schemaNameValue);
        if (schemaBranchNameValue != null && !schemaBranchNameValue.isBlank()) {
            identifierBuilder.branch(schemaBranchNameValue);
        }
        if (schemaVersionValue != null && !schemaVersionValue.isBlank()) {
            try {
                identifierBuilder.version(Integer.valueOf(schemaVersionValue));
            }
            catch (NumberFormatException nfe) {
                throw new SchemaNotFoundException("Could not retrieve schema with name '%s' because a non-numeric version was supplied '%s'".formatted(schemaNameValue, schemaVersionValue), (Throwable)nfe);
            }
        }
        return identifierBuilder.build();
    }

    private void validateSchemaText(String schemaTextString) throws SchemaNotFoundException {
        if (schemaTextString == null || schemaTextString.isBlank()) {
            throw new SchemaNotFoundException("Schema text not found");
        }
    }

    private void validateSchemaName(String schemaNameValue) throws SchemaNotFoundException {
        if (schemaNameValue == null || schemaNameValue.isBlank()) {
            throw new SchemaNotFoundException("Schema name not provided or is blank");
        }
    }

    static enum MessageNameResolverStrategy implements DescribedValue
    {
        MESSAGE_NAME_PROPERTY("Message Name Property", "Use the 'Message Name' property value to determine the message name"),
        MESSAGE_NAME_RESOLVER("Message Name Resolver", "Use a 'Message Name Resolver' service to dynamically determine the message name");

        private final String displayName;
        private final String description;

        private MessageNameResolverStrategy(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    static class PropertyMessageNameResolver
    extends AbstractControllerService
    implements MessageNameResolver {
        private final PropertyContext context;

        PropertyMessageNameResolver(PropertyContext context) {
            this.context = context;
        }

        public MessageName getMessageName(Map<String, String> variables, SchemaDefinition schemaDefinition, InputStream in) {
            String messageName = this.context.getProperty(MESSAGE_NAME).evaluateAttributeExpressions(variables).getValue();
            return StandardMessageNameFactory.fromName((String)messageName);
        }
    }
}

