/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.protobuf;

import org.apache.nifi.schemaregistry.services.SchemaDefinition;
import org.apache.nifi.serialization.record.SchemaIdentifier;

final class ProtobufSchemaValidator {
    private ProtobufSchemaValidator() {
    }

    static void validateSchemaDefinitionIdentifiers(SchemaDefinition schemaDefinition, boolean isRootSchemaDefinition) {
        if (!isRootSchemaDefinition) {
            ProtobufSchemaValidator.validateSchemaIdentifier(schemaDefinition.getIdentifier());
        }
        for (SchemaDefinition referencedSchema : schemaDefinition.getReferences().values()) {
            ProtobufSchemaValidator.validateSchemaDefinitionIdentifiers(referencedSchema, false);
        }
    }

    private static void validateSchemaIdentifier(SchemaIdentifier schemaIdentifier) {
        schemaIdentifier.getName().filter(name -> name.endsWith(".proto")).orElseThrow(() -> new IllegalArgumentException("Schema identifier must have a name that ends with .proto extension. Schema identifier: " + String.valueOf(schemaIdentifier)));
    }
}

