/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.put.sender;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.put.sender.ChannelSender;
import org.apache.nifi.remote.io.socket.SocketChannelOutputStream;

public class SocketChannelSender
extends ChannelSender {
    protected SocketChannel channel;
    protected SocketChannelOutputStream socketChannelOutput;

    public SocketChannelSender(String host, int port, int maxSendBufferSize, ComponentLog logger) {
        super(host, port, maxSendBufferSize, logger);
    }

    @Override
    public void open() throws IOException {
        try {
            if (this.channel == null) {
                this.channel = SocketChannel.open();
                this.channel.configureBlocking(false);
                if (this.maxSendBufferSize > 0) {
                    this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.maxSendBufferSize);
                    int actualSendBufSize = this.channel.getOption(StandardSocketOptions.SO_SNDBUF);
                    if (actualSendBufSize < this.maxSendBufferSize) {
                        this.logger.warn("Attempted to set Socket Send Buffer Size to " + this.maxSendBufferSize + " bytes but could only set to " + actualSendBufSize + "bytes. You may want to consider changing the Operating System's maximum send buffer");
                    }
                }
            }
            if (!this.channel.isConnected()) {
                SocketAddress localAddress;
                long startTime = System.currentTimeMillis();
                InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName(this.host), this.port);
                if (!this.channel.connect(socketAddress)) {
                    while (!this.channel.finishConnect()) {
                        if (System.currentTimeMillis() > startTime + (long)this.timeout) {
                            throw new SocketTimeoutException("Timed out connecting to " + this.host + ":" + this.port);
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.logger.isDebugEnabled() && (localAddress = this.channel.getLocalAddress()) != null && localAddress instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)localAddress;
                    this.logger.debug("Connected to local port {}", new Object[]{inetSocketAddress.getPort()});
                }
                this.socketChannelOutput = new SocketChannelOutputStream(this.channel);
                this.socketChannelOutput.setTimeout(this.timeout);
            }
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Closeable)this.channel);
            throw e;
        }
    }

    @Override
    protected void write(byte[] data) throws IOException {
        this.socketChannelOutput.write(data);
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.socketChannelOutput);
        IOUtils.closeQuietly((Closeable)this.channel);
        this.socketChannelOutput = null;
        this.channel = null;
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                SocketChannelSender.this.socketChannelOutput.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                SocketChannelSender.this.socketChannelOutput.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                SocketChannelSender.this.socketChannelOutput.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                SocketChannelSender.this.socketChannelOutput.close();
            }

            @Override
            public void flush() throws IOException {
                SocketChannelSender.this.socketChannelOutput.flush();
                SocketChannelSender.this.updateLastUsed();
            }
        };
    }

    private void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }
}

