/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store.iterator;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.store.RecordReaderFactory;
import org.apache.nifi.provenance.store.iterator.EventIterator;
import org.apache.nifi.provenance.util.DirectoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveRecordReaderEventIterator
implements EventIterator {
    private static final Logger logger = LoggerFactory.getLogger(SelectiveRecordReaderEventIterator.class);
    private final List<File> files;
    private final RecordReaderFactory readerFactory;
    private final List<Long> eventIds;
    private final Iterator<Long> idIterator;
    private final int maxAttributeChars;
    private boolean closed = false;
    private RecordReader reader;
    private File currentFile;

    public SelectiveRecordReaderEventIterator(List<File> filesToRead, RecordReaderFactory readerFactory, List<Long> eventIds, int maxAttributeChars) {
        this.readerFactory = readerFactory;
        this.eventIds = new ArrayList<Long>(eventIds);
        Collections.sort(this.eventIds);
        this.idIterator = this.eventIds.iterator();
        this.files = eventIds.isEmpty() || filesToRead.isEmpty() ? Collections.emptyList() : SelectiveRecordReaderEventIterator.filterUnneededFiles(filesToRead, this.eventIds);
        this.maxAttributeChars = maxAttributeChars;
    }

    protected static List<File> filterUnneededFiles(List<File> filesToRead, List<Long> eventIds) {
        ArrayList<File> files = new ArrayList<File>();
        Long firstEventId = eventIds.get(0);
        Long lastEventId = eventIds.get(eventIds.size() - 1);
        ArrayList<File> sortedFileList = new ArrayList<File>(filesToRead);
        Collections.sort(sortedFileList, DirectoryUtils.SMALLEST_ID_FIRST);
        File lastFile = null;
        for (File file : filesToRead) {
            long firstIdInFile = DirectoryUtils.getMinId(file);
            if (firstIdInFile > lastEventId) continue;
            if (firstIdInFile > firstEventId) {
                if (files.isEmpty() && lastFile != null) {
                    files.add(lastFile);
                }
                files.add(file);
            }
            lastFile = file;
        }
        if (files.isEmpty() && lastFile != null) {
            files.add(lastFile);
        }
        return files;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<ProvenanceEventRecord> nextEvent() throws IOException {
        if (this.closed) {
            throw new IOException("EventIterator is already closed");
        }
        long start = System.nanoTime();
        try {
            while (this.idIterator.hasNext()) {
                long eventId = this.idIterator.next();
                File fileForEvent = this.getFileForEventId(eventId);
                if (fileForEvent == null) continue;
                try {
                    Optional<ProvenanceEventRecord> eventOption;
                    if (!fileForEvent.equals(this.currentFile)) {
                        if (this.reader != null) {
                            try {
                                this.reader.close();
                            }
                            catch (Exception e) {
                                logger.warn("Failed to close {}; some resources may not be cleaned up appropriately", (Object)this.reader);
                            }
                        }
                        this.reader = this.readerFactory.newRecordReader(fileForEvent, Collections.emptyList(), this.maxAttributeChars);
                        this.currentFile = fileForEvent;
                    }
                    if (!(eventOption = this.reader.skipToEvent(eventId)).isPresent() || eventOption.get().getEventId() != eventId) continue;
                    this.reader.nextRecord();
                    Optional<ProvenanceEventRecord> optional = eventOption;
                    return optional;
                }
                catch (EOFException | FileNotFoundException e) {
                    logger.warn("Failed to retrieve Event with ID {}", (Object)eventId, (Object)e);
                }
            }
            Optional<ProvenanceEventRecord> optional = Optional.empty();
            return optional;
        }
        finally {
            long ms = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            logger.trace("Took {} ms to read next event", (Object)ms);
        }
    }

    private File getFileForEventId(long eventId) {
        File lastFile = null;
        for (File file : this.files) {
            long firstEventId = DirectoryUtils.getMinId(file);
            if (firstEventId == eventId) {
                return file;
            }
            if (firstEventId > eventId) {
                return lastFile;
            }
            lastFile = file;
        }
        return lastFile;
    }
}

