/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.serialization.RecordReaders;
import org.apache.nifi.provenance.toc.TocReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocsReader {
    private final Logger logger = LoggerFactory.getLogger(DocsReader.class);

    public Set<ProvenanceEventRecord> read(TopDocs topDocs, EventAuthorizer authorizer, IndexReader indexReader, Collection<Path> allProvenanceLogFiles, AtomicInteger retrievalCount, int maxResults, int maxAttributeChars) throws IOException {
        if (retrievalCount.get() >= maxResults) {
            return Collections.emptySet();
        }
        long start = System.nanoTime();
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        int numDocs = Math.min(scoreDocs.length, maxResults);
        ArrayList<Document> docs = new ArrayList<Document>(numDocs);
        StoredFields storedFields = indexReader.storedFields();
        for (int i = numDocs - 1; i >= 0; --i) {
            int docId = scoreDocs[i].doc;
            Document d = storedFields.document(docId);
            docs.add(d);
        }
        long readDocuments = System.nanoTime() - start;
        this.logger.debug("Reading {} Lucene Documents took {} millis", (Object)docs.size(), (Object)TimeUnit.NANOSECONDS.toMillis(readDocuments));
        return this.read(docs, authorizer, allProvenanceLogFiles, retrievalCount, maxResults, maxAttributeChars);
    }

    private long getByteOffset(Document d, RecordReader reader) {
        IndexableField blockField = d.getField("block-index");
        if (blockField != null) {
            int blockIndex = blockField.numericValue().intValue();
            TocReader tocReader = reader.getTocReader();
            return tocReader.getBlockOffset(blockIndex);
        }
        return d.getField("storage-fileOffset").numericValue().longValue();
    }

    private ProvenanceEventRecord getRecord(Document d, RecordReader reader) throws IOException {
        IndexableField idField;
        StandardProvenanceEventRecord record;
        IndexableField blockField = d.getField("block-index");
        if (blockField == null) {
            reader.skipTo(this.getByteOffset(d, reader));
        } else {
            reader.skipToBlock(blockField.numericValue().intValue());
        }
        while ((record = reader.nextRecord()) != null && (idField = d.getField(SearchableFields.Identifier.getSearchableFieldName())) != null && idField.numericValue().longValue() != record.getEventId()) {
        }
        if (record == null) {
            this.logger.warn("Failed to read Provenance Event for '{}'. The event file may be missing or corrupted", (Object)d);
        }
        return record;
    }

    public Set<ProvenanceEventRecord> read(List<Document> docs, EventAuthorizer authorizer, Collection<Path> allProvenanceLogFiles, AtomicInteger retrievalCount, int maxResults, int maxAttributeChars) throws IOException {
        if (retrievalCount.get() >= maxResults) {
            return Collections.emptySet();
        }
        long start = System.nanoTime();
        LinkedHashSet<ProvenanceEventRecord> matchingRecords = new LinkedHashSet<ProvenanceEventRecord>();
        Map<String, List<Document>> byStorageNameDocGroups = LuceneUtil.groupDocsByStorageFileName(docs);
        int eventsReadThisFile = 0;
        int logFileCount = 0;
        for (String storageFileName : byStorageNameDocGroups.keySet()) {
            File provenanceEventFile = LuceneUtil.getProvenanceLogFile(storageFileName, allProvenanceLogFiles);
            if (provenanceEventFile == null) {
                this.logger.warn("Could not find Provenance Log File with basename {} in the Provenance Repository; assuming file has expired and continuing without it", (Object)storageFileName);
                continue;
            }
            try {
                RecordReader reader = RecordReaders.newRecordReader(provenanceEventFile, allProvenanceLogFiles, maxAttributeChars);
                try {
                    Iterator<Document> docIter = byStorageNameDocGroups.get(storageFileName).iterator();
                    while (docIter.hasNext() && retrievalCount.getAndIncrement() < maxResults) {
                        ProvenanceEventRecord event = this.getRecord(docIter.next(), reader);
                        if (event == null || !authorizer.isAuthorized(event)) continue;
                        matchingRecords.add(event);
                        ++eventsReadThisFile;
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to read Provenance Events. The event file '" + provenanceEventFile.getAbsolutePath() + "' may be missing or corrupt.", (Throwable)e);
            }
        }
        this.logger.debug("Read {} records from previous file", (Object)eventsReadThisFile);
        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        this.logger.debug("Took {} ms to read {} events from {} prov log files", new Object[]{millis, matchingRecords.size(), logFileCount});
        return matchingRecords;
    }
}

