/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.index.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.nifi.provenance.ProgressiveResult;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.provenance.authorization.EventTransformer;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.apache.nifi.provenance.index.SearchFailedException;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.store.EventStore;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(QueryTask.class);
    private static final Set<String> LUCENE_FIELDS_TO_LOAD = Collections.singleton(SearchableFields.Identifier.getSearchableFieldName());
    private final Query query;
    private final ProgressiveResult queryResult;
    private final int maxResults;
    private final IndexManager indexManager;
    private final File indexDir;
    private final EventStore eventStore;
    private final EventAuthorizer authorizer;
    private final EventTransformer transformer;

    public QueryTask(Query query, ProgressiveResult result, int maxResults, IndexManager indexManager, File indexDir, EventStore eventStore, EventAuthorizer authorizer, EventTransformer unauthorizedTransformer) {
        this.query = query;
        this.queryResult = result;
        this.maxResults = maxResults;
        this.indexManager = indexManager;
        this.indexDir = indexDir;
        this.eventStore = eventStore;
        this.authorizer = authorizer;
        this.transformer = unauthorizedTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        EventIndexSearcher searcher;
        if (this.queryResult.getTotalHitCount() >= (long)this.maxResults) {
            logger.debug("Will not query lucene index {} because maximum results have already been obtained", (Object)this.indexDir);
            this.queryResult.update(Collections.emptyList(), 0L);
            return;
        }
        if (this.queryResult.isFinished()) {
            logger.debug("Will not query lucene index {} because the query is already finished", (Object)this.indexDir);
            return;
        }
        long borrowStart = System.nanoTime();
        try {
            searcher = this.indexManager.borrowIndexSearcher(this.indexDir);
        }
        catch (FileNotFoundException fnfe) {
            this.queryResult.update(Collections.emptyList(), 0L);
            logger.info("Attempted to search Provenance Index {} but could not find the directory or the directory did not contain a valid Lucene index. This usually indicates that either the index was just created and hasn't fully been initialized, or that the index was recently aged off.", (Object)this.indexDir);
            return;
        }
        catch (IOException ioe) {
            this.queryResult.setError("Failed to query index " + String.valueOf(this.indexDir) + "; see logs for more details");
            logger.error("Failed to query index {}", (Object)this.indexDir, (Object)ioe);
            return;
        }
        try {
            TopFieldDocs topDocs;
            StoredFields storedFields;
            long borrowMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - borrowStart);
            logger.trace("Borrowing index searcher for {} took {} ms", (Object)this.indexDir, (Object)borrowMillis);
            long startNanos = System.nanoTime();
            if (this.queryResult.getTotalHitCount() >= (long)this.maxResults) {
                logger.debug("Will not query lucene index {} because maximum results have already been obtained", (Object)this.indexDir);
                this.queryResult.update(Collections.emptyList(), 0L);
                return;
            }
            if (this.queryResult.isFinished()) {
                logger.debug("Will not query lucene index {} because the query is already finished", (Object)this.indexDir);
                return;
            }
            IndexReader indexReader = searcher.getIndexSearcher().getIndexReader();
            try {
                storedFields = indexReader.storedFields();
                Sort sort = new Sort(new SortField[]{new SortField(null, SortField.Type.DOC, true)});
                topDocs = searcher.getIndexSearcher().search(this.query, this.maxResults, sort);
            }
            catch (Exception e) {
                logger.error("Failed to query Lucene for index {}", (Object)this.indexDir, (Object)e);
                this.queryResult.setError("Failed to query Lucene for index " + String.valueOf(this.indexDir) + " due to " + String.valueOf(e));
                this.indexManager.returnIndexSearcher(searcher);
                return;
            }
            finally {
                long ms = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                logger.debug("Querying Lucene for index {} took {} ms", (Object)this.indexDir, (Object)ms);
            }
            if (this.queryResult.getTotalHitCount() < (long)this.maxResults) {
                if (this.queryResult.isFinished()) {
                    logger.debug("Will not read events from store for {} because the query has already finished", (Object)this.indexDir);
                    return;
                }
                Tuple<List<ProvenanceEventRecord>, Long> eventsAndTotalHits = this.readDocuments((TopDocs)topDocs, storedFields);
                if (eventsAndTotalHits == null) {
                    this.queryResult.update(Collections.emptyList(), 0L);
                    logger.info("Will not update query results for queried index {} for query {} because the maximum number of results have been reached already", (Object)this.indexDir, (Object)this.query);
                    return;
                }
                this.queryResult.update((Collection)eventsAndTotalHits.getKey(), ((Long)eventsAndTotalHits.getValue()).longValue());
                long searchNanos = System.nanoTime() - startNanos;
                long millis = TimeUnit.NANOSECONDS.toMillis(searchNanos);
                logger.info("Successfully queried index {} for query {}; retrieved {} events with a total of {} hits in {} millis", new Object[]{this.indexDir, this.query, ((List)eventsAndTotalHits.getKey()).size(), eventsAndTotalHits.getValue(), millis});
                return;
            }
        }
        catch (Exception e) {
            logger.error("Failed to query events against index {}", (Object)this.indexDir, (Object)e);
            this.queryResult.setError("Failed to complete query due to " + String.valueOf(e));
            return;
        }
        logger.debug("Will not read events from store for {} because maximum results have already been obtained", (Object)this.indexDir);
        this.queryResult.update(Collections.emptyList(), 0L);
        return;
        finally {
            this.indexManager.returnIndexSearcher(searcher);
        }
    }

    private Tuple<List<ProvenanceEventRecord>, Long> readDocuments(TopDocs topDocs, StoredFields storedFields) {
        List<ProvenanceEventRecord> events;
        if (topDocs == null || topDocs.totalHits.value() == 0L) {
            return new Tuple(Collections.emptyList(), (Object)0L);
        }
        long start = System.nanoTime();
        List<Long> eventIds = Arrays.stream(topDocs.scoreDocs).mapToInt(scoreDoc -> scoreDoc.doc).mapToObj(docId -> {
            try {
                return storedFields.document(docId, LUCENE_FIELDS_TO_LOAD);
            }
            catch (Exception e) {
                throw new SearchFailedException("Failed to read Provenance Events from Event File", e);
            }
        }).map(doc -> doc.getField(SearchableFields.Identifier.getSearchableFieldName()).numericValue().longValue()).collect(Collectors.toList());
        long endConvert = System.nanoTime();
        long ms = TimeUnit.NANOSECONDS.toMillis(endConvert - start);
        logger.trace("Converting documents took {} ms", (Object)ms);
        try {
            events = this.eventStore.getEvents(eventIds, this.authorizer, this.transformer);
        }
        catch (IOException e) {
            throw new SearchFailedException("Unable to retrieve events from the Provenance Store", e);
        }
        long fetchEventNanos = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - endConvert);
        logger.debug("Fetching {} events from Event Store took {} ms ({} events actually fetched)", new Object[]{eventIds.size(), fetchEventNanos, events.size()});
        long totalHits = topDocs.totalHits.value();
        return new Tuple(events, (Object)totalHits);
    }
}

