/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.authorization;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.provenance.PlaceholderProvenanceEvent;
import org.apache.nifi.provenance.ProvenanceEventRecord;

public interface EventAuthorizer {
    public static final EventAuthorizer GRANT_ALL = new EventAuthorizer(){

        @Override
        public boolean isAuthorized(ProvenanceEventRecord event) {
            return true;
        }

        @Override
        public void authorize(ProvenanceEventRecord event) throws AccessDeniedException {
        }

        @Override
        public List<ProvenanceEventRecord> filterUnauthorizedEvents(List<ProvenanceEventRecord> events) {
            return events;
        }

        @Override
        public Set<ProvenanceEventRecord> replaceUnauthorizedWithPlaceholders(Set<ProvenanceEventRecord> events) {
            return events;
        }
    };
    public static final EventAuthorizer DENY_ALL = new EventAuthorizer(){

        @Override
        public boolean isAuthorized(ProvenanceEventRecord event) {
            return false;
        }

        @Override
        public void authorize(ProvenanceEventRecord event) throws AccessDeniedException {
            throw new AccessDeniedException();
        }

        @Override
        public List<ProvenanceEventRecord> filterUnauthorizedEvents(List<ProvenanceEventRecord> events) {
            return Collections.emptyList();
        }

        @Override
        public Set<ProvenanceEventRecord> replaceUnauthorizedWithPlaceholders(Set<ProvenanceEventRecord> events) {
            return events.stream().map(event -> new PlaceholderProvenanceEvent(event)).collect(Collectors.toSet());
        }
    };

    public boolean isAuthorized(ProvenanceEventRecord var1);

    public void authorize(ProvenanceEventRecord var1) throws AccessDeniedException;

    default public List<ProvenanceEventRecord> filterUnauthorizedEvents(List<ProvenanceEventRecord> events) {
        return events.stream().filter(event -> this.isAuthorized((ProvenanceEventRecord)event)).collect(Collectors.toList());
    }

    default public Set<ProvenanceEventRecord> replaceUnauthorizedWithPlaceholders(Set<ProvenanceEventRecord> events) {
        return events.stream().map(event -> this.isAuthorized((ProvenanceEventRecord)event) ? event : new PlaceholderProvenanceEvent(event)).collect(Collectors.toSet());
    }
}

