/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.provenance.SearchableFieldParser;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryConfiguration.class);
    public static final String CONCURRENT_MERGE_THREADS = "nifi.provenance.repository.concurrent.merge.threads";
    public static final String WARM_CACHE_FREQUENCY = "nifi.provenance.repository.warm.cache.frequency";
    public static final String MAINTENACE_FREQUENCY = "nifi.provenance.repository.maintenance.frequency";
    private final Map<String, File> storageDirectories = new LinkedHashMap<String, File>();
    private long recordLifeMillis = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    private long storageCapacity = 0x40000000L;
    private long eventFileMillis = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private long eventFileBytes = 0x500000L;
    private int maxFileEvents = Integer.MAX_VALUE;
    private long desiredIndexBytes = 524288000L;
    private int journalCount = 16;
    private int compressionBlockBytes = 0x100000;
    private int maxAttributeChars = 65536;
    private int debugFrequency = 1000000;
    private long maintenanceFrequencyMillis = TimeUnit.MINUTES.toMillis(1L);
    private List<SearchableField> searchableFields = new ArrayList<SearchableField>();
    private List<SearchableField> searchableAttributes = new ArrayList<SearchableField>();
    private boolean compress = true;
    private boolean alwaysSync = false;
    private int queryThreadPoolSize = 2;
    private int indexThreadPoolSize = 1;
    private boolean allowRollover = true;
    private int concurrentMergeThreads = 4;
    private Integer warmCacheFrequencyMinutes = null;

    public void setAllowRollover(boolean allow) {
        this.allowRollover = allow;
    }

    public boolean isAllowRollover() {
        return this.allowRollover;
    }

    public int getCompressionBlockBytes() {
        return this.compressionBlockBytes;
    }

    public void setCompressionBlockBytes(int compressionBlockBytes) {
        this.compressionBlockBytes = compressionBlockBytes;
    }

    public Map<String, File> getStorageDirectories() {
        return Collections.unmodifiableMap(this.storageDirectories);
    }

    public void addStorageDirectory(String partitionName, File storageDirectory) {
        this.storageDirectories.put(partitionName, storageDirectory);
    }

    public void addStorageDirectories(Map<String, File> storageDirectories) {
        this.storageDirectories.putAll(storageDirectories);
    }

    public long getMaxRecordLife(TimeUnit timeUnit) {
        return timeUnit.convert(this.recordLifeMillis, TimeUnit.MILLISECONDS);
    }

    public void setMaxRecordLife(long maxRecordLife, TimeUnit timeUnit) {
        this.recordLifeMillis = TimeUnit.MILLISECONDS.convert(maxRecordLife, timeUnit);
    }

    public long getMaxStorageCapacity() {
        return this.storageCapacity;
    }

    public void setMaxStorageCapacity(long maxStorageCapacity) {
        this.storageCapacity = maxStorageCapacity;
    }

    public long getMaxEventFileLife(TimeUnit timeUnit) {
        return timeUnit.convert(this.eventFileMillis, TimeUnit.MILLISECONDS);
    }

    public void setMaxEventFileLife(long maxEventFileTime, TimeUnit timeUnit) {
        this.eventFileMillis = TimeUnit.MILLISECONDS.convert(maxEventFileTime, timeUnit);
    }

    public long getMaxEventFileCapacity() {
        return this.eventFileBytes;
    }

    public void setMaxEventFileCapacity(long maxEventFileBytes) {
        this.eventFileBytes = maxEventFileBytes;
    }

    public int getMaxEventFileCount() {
        return this.maxFileEvents;
    }

    public void setMaxEventFileCount(int maxCount) {
        this.maxFileEvents = maxCount;
    }

    public List<SearchableField> getSearchableFields() {
        return Collections.unmodifiableList(this.searchableFields);
    }

    public void setSearchableFields(List<SearchableField> searchableFields) {
        this.searchableFields = new ArrayList<SearchableField>(searchableFields);
    }

    public List<SearchableField> getSearchableAttributes() {
        return Collections.unmodifiableList(this.searchableAttributes);
    }

    public void setSearchableAttributes(List<SearchableField> searchableAttributes) {
        this.searchableAttributes = new ArrayList<SearchableField>(searchableAttributes);
    }

    public boolean isCompressOnRollover() {
        return this.compress;
    }

    public void setCompressOnRollover(boolean compress) {
        this.compress = compress;
    }

    public int getQueryThreadPoolSize() {
        return this.queryThreadPoolSize;
    }

    public void setQueryThreadPoolSize(int queryThreadPoolSize) {
        if (queryThreadPoolSize < 1) {
            throw new IllegalArgumentException();
        }
        this.queryThreadPoolSize = queryThreadPoolSize;
    }

    public int getIndexThreadPoolSize() {
        return this.indexThreadPoolSize;
    }

    public void setIndexThreadPoolSize(int indexThreadPoolSize) {
        if (indexThreadPoolSize < 1) {
            throw new IllegalArgumentException();
        }
        this.indexThreadPoolSize = indexThreadPoolSize;
    }

    public void setConcurrentMergeThreads(int mergeThreads) {
        this.concurrentMergeThreads = mergeThreads;
    }

    public int getConcurrentMergeThreads() {
        return this.concurrentMergeThreads;
    }

    public void setDesiredIndexSize(long bytes) {
        this.desiredIndexBytes = bytes;
    }

    public long getDesiredIndexSize() {
        return this.desiredIndexBytes;
    }

    public void setJournalCount(int numJournals) {
        if (numJournals < 1) {
            throw new IllegalArgumentException();
        }
        this.journalCount = numJournals;
    }

    public int getJournalCount() {
        return this.journalCount;
    }

    public boolean isAlwaysSync() {
        return this.alwaysSync;
    }

    public void setAlwaysSync(boolean alwaysSync) {
        this.alwaysSync = alwaysSync;
    }

    public int getMaxAttributeChars() {
        return this.maxAttributeChars;
    }

    public void setMaxAttributeChars(int maxAttributeChars) {
        this.maxAttributeChars = maxAttributeChars;
    }

    public void setWarmCacheFrequencyMinutes(Integer frequencyMinutes) {
        this.warmCacheFrequencyMinutes = frequencyMinutes;
    }

    public Optional<Integer> getWarmCacheFrequencyMinutes() {
        return Optional.ofNullable(this.warmCacheFrequencyMinutes);
    }

    public int getDebugFrequency() {
        return this.debugFrequency;
    }

    public void setDebugFrequency(int debugFrequency) {
        this.debugFrequency = debugFrequency;
    }

    public long getMaintenanceFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.maintenanceFrequencyMillis, TimeUnit.MILLISECONDS);
    }

    public void setMaintenanceFrequency(long period, TimeUnit timeUnit) {
        this.maintenanceFrequencyMillis = timeUnit.toMillis(period);
    }

    public static RepositoryConfiguration create(NiFiProperties nifiProperties) {
        int maxAttrChars;
        Map storageDirectories = nifiProperties.getProvenanceRepositoryPaths();
        if (storageDirectories.isEmpty()) {
            storageDirectories.put("provenance_repository", Paths.get("provenance_repository", new String[0]));
        }
        String storageTime = nifiProperties.getProperty("nifi.provenance.repository.max.storage.time", "24 hours");
        String storageSize = nifiProperties.getProperty("nifi.provenance.repository.max.storage.size", "1 GB");
        String rolloverTime = nifiProperties.getProperty("nifi.provenance.repository.rollover.time", "5 mins");
        String rolloverSize = nifiProperties.getProperty("nifi.provenance.repository.rollover.size", "100 MB");
        int rolloverEventCount = nifiProperties.getIntegerProperty("nifi.provenance.repository.rollover.events", Integer.valueOf(Integer.MAX_VALUE));
        String shardSize = nifiProperties.getProperty("nifi.provenance.repository.index.shard.size", "500 MB");
        int queryThreads = nifiProperties.getIntegerProperty("nifi.provenance.repository.query.threads", Integer.valueOf(2));
        int indexThreads = nifiProperties.getIntegerProperty("nifi.provenance.repository.index.threads", Integer.valueOf(2));
        int journalCount = nifiProperties.getIntegerProperty("nifi.provenance.repository.journal.count", Integer.valueOf(16));
        int concurrentMergeThreads = nifiProperties.getIntegerProperty(CONCURRENT_MERGE_THREADS, Integer.valueOf(2));
        String warmCacheFrequency = nifiProperties.getProperty(WARM_CACHE_FREQUENCY);
        String maintenanceFrequency = nifiProperties.getProperty(MAINTENACE_FREQUENCY);
        long storageMillis = FormatUtils.getTimeDuration((String)storageTime, (TimeUnit)TimeUnit.MILLISECONDS);
        long maxStorageBytes = DataUnit.parseDataSize((String)storageSize, (DataUnit)DataUnit.B).longValue();
        long rolloverMillis = FormatUtils.getTimeDuration((String)rolloverTime, (TimeUnit)TimeUnit.MILLISECONDS);
        long rolloverBytes = DataUnit.parseDataSize((String)rolloverSize, (DataUnit)DataUnit.B).longValue();
        boolean compressOnRollover = Boolean.parseBoolean(nifiProperties.getProperty("nifi.provenance.repository.compress.on.rollover"));
        String indexedFieldString = nifiProperties.getProperty("nifi.provenance.repository.indexed.fields");
        String indexedAttrString = nifiProperties.getProperty("nifi.provenance.repository.indexed.attributes");
        Boolean alwaysSync = Boolean.parseBoolean(nifiProperties.getProperty("nifi.provenance.repository.always.sync", "false"));
        int defaultMaxAttrChars = 65536;
        String maxAttrLength = nifiProperties.getProperty("nifi.provenance.repository.max.attribute.length", String.valueOf(65536));
        try {
            maxAttrChars = Integer.parseInt(maxAttrLength);
            if (maxAttrChars < 36) {
                maxAttrChars = 36;
                logger.warn("Found max attribute length property set to {} but minimum length is 36; using 36 instead", (Object)maxAttrLength);
            }
        }
        catch (Exception e) {
            maxAttrChars = 65536;
        }
        List searchableFields = SearchableFieldParser.extractSearchableFields((String)indexedFieldString, (boolean)true);
        List searchableAttributes = SearchableFieldParser.extractSearchableFields((String)indexedAttrString, (boolean)false);
        if (!searchableFields.contains(SearchableFields.EventTime)) {
            searchableFields.add(SearchableFields.EventTime);
        }
        RepositoryConfiguration config = new RepositoryConfiguration();
        for (Map.Entry entry : storageDirectories.entrySet()) {
            config.addStorageDirectory((String)entry.getKey(), ((Path)entry.getValue()).toFile());
        }
        config.setCompressOnRollover(compressOnRollover);
        config.setSearchableFields(searchableFields);
        config.setSearchableAttributes(searchableAttributes);
        config.setMaxEventFileCapacity(rolloverBytes);
        config.setMaxEventFileCount(rolloverEventCount);
        config.setMaxEventFileLife(rolloverMillis, TimeUnit.MILLISECONDS);
        config.setMaxRecordLife(storageMillis, TimeUnit.MILLISECONDS);
        config.setMaxStorageCapacity(maxStorageBytes);
        config.setQueryThreadPoolSize(queryThreads);
        config.setIndexThreadPoolSize(indexThreads);
        config.setJournalCount(journalCount);
        config.setMaxAttributeChars(maxAttrChars);
        config.setConcurrentMergeThreads(concurrentMergeThreads);
        if (warmCacheFrequency != null && !warmCacheFrequency.trim().equals("")) {
            config.setWarmCacheFrequencyMinutes((int)FormatUtils.getTimeDuration((String)warmCacheFrequency, (TimeUnit)TimeUnit.MINUTES));
        }
        if (shardSize != null) {
            config.setDesiredIndexSize(DataUnit.parseDataSize((String)shardSize, (DataUnit)DataUnit.B).longValue());
        }
        if (maintenanceFrequency != null && !maintenanceFrequency.trim().equals("")) {
            long millis = FormatUtils.getTimeDuration((String)maintenanceFrequency.trim(), (TimeUnit)TimeUnit.MILLISECONDS);
            config.setMaintenanceFrequency(millis, TimeUnit.MILLISECONDS);
        }
        config.setAlwaysSync(alwaysSync);
        config.setDebugFrequency(nifiProperties.getIntegerProperty("nifi.provenance.repository.debug.frequency", Integer.valueOf(config.getDebugFrequency())));
        return config;
    }
}

