/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.MessageDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.processors.opentelemetry.encoding.HexadecimalByteStringField;

public class ByteStringFieldDeserializer<T extends Message, V extends Message.Builder>
extends MessageDeserializer<T, V> {
    private static final Set<String> HEXADECIMAL_BYTE_STRING_FIELDS = Arrays.stream(HexadecimalByteStringField.values()).map(HexadecimalByteStringField::getField).collect(Collectors.toSet());

    public ByteStringFieldDeserializer(Class<T> messageType, ProtobufJacksonConfig config) {
        super(messageType, config);
    }

    protected Object readValue(Message.Builder builder, Descriptors.FieldDescriptor field, Message defaultInstance, JsonParser parser, DeserializationContext context) throws IOException {
        Object value;
        String jsonName = field.getJsonName();
        if (HEXADECIMAL_BYTE_STRING_FIELDS.contains(jsonName)) {
            String encoded = parser.getValueAsString();
            if (encoded == null) {
                value = null;
            } else {
                try {
                    byte[] decoded = Hex.decodeHex((String)encoded);
                    value = ByteString.copyFrom((byte[])decoded);
                }
                catch (DecoderException e) {
                    throw new IOException(String.format("Hexadecimal Field [%s] decoding failed", jsonName), e);
                }
            }
        } else {
            value = super.readValue(builder, field, defaultInstance, parser, context);
        }
        return value;
    }
}

