/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.io;

import com.google.protobuf.Message;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.logs.v1.ResourceLogs;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.processors.opentelemetry.encoding.RequestMapper;
import org.apache.nifi.processors.opentelemetry.encoding.StandardRequestMapper;
import org.apache.nifi.processors.opentelemetry.io.RequestCallback;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryRequestType;

class StandardRequestCallback
implements RequestCallback {
    private static final String APPLICATION_JSON = "application/json";
    private static final RequestMapper REQUEST_MAPPER = new StandardRequestMapper();
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Class<? extends Message> messageClass;
    private final List<Message> messages;
    private final String transitUri;

    StandardRequestCallback(TelemetryRequestType requestType, Class<? extends Message> messageClass, List<Message> messages, String transitUri) {
        this.messageClass = Objects.requireNonNull(messageClass, "Message Class required");
        this.messages = Objects.requireNonNull(messages, "Messages required");
        this.transitUri = Objects.requireNonNull(transitUri, "Transit URI required");
        this.attributes.put("mime.type", APPLICATION_JSON);
        this.attributes.put("resource.type", requestType.name());
        this.attributes.put("resource.count", Integer.toString(messages.size()));
    }

    public void process(OutputStream outputStream) throws IOException {
        if (ResourceLogs.class.isAssignableFrom(this.messageClass)) {
            ExportLogsServiceRequest.Builder requestBuilder = ExportLogsServiceRequest.newBuilder();
            for (Message message : this.messages) {
                ResourceLogs resourceLogs = (ResourceLogs)message;
                requestBuilder.addResourceLogs(resourceLogs);
            }
            ExportLogsServiceRequest request = requestBuilder.build();
            REQUEST_MAPPER.writeValue(outputStream, (Message)request);
        } else if (ResourceMetrics.class.isAssignableFrom(this.messageClass)) {
            ExportMetricsServiceRequest.Builder requestBuilder = ExportMetricsServiceRequest.newBuilder();
            for (Message message : this.messages) {
                ResourceMetrics currentResourceMetrics = (ResourceMetrics)message;
                requestBuilder.addResourceMetrics(currentResourceMetrics);
            }
            ExportMetricsServiceRequest request = requestBuilder.build();
            REQUEST_MAPPER.writeValue(outputStream, (Message)request);
        } else if (ResourceSpans.class.isAssignableFrom(this.messageClass)) {
            ExportTraceServiceRequest.Builder requestBuilder = ExportTraceServiceRequest.newBuilder();
            for (Message message : this.messages) {
                ResourceSpans resourceSpans = (ResourceSpans)message;
                requestBuilder.addResourceSpans(resourceSpans);
            }
            ExportTraceServiceRequest request = requestBuilder.build();
            REQUEST_MAPPER.writeValue(outputStream, (Message)request);
        } else {
            throw new IllegalArgumentException(String.format("Request Class [%s] not supported", this.messageClass));
        }
    }

    @Override
    public String getTransitUri() {
        return this.transitUri;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

