/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.google.protobuf.Message;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsPartialSuccess;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceResponse;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsPartialSuccess;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import io.opentelemetry.proto.collector.trace.v1.ExportTracePartialSuccess;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.nifi.processors.opentelemetry.encoding.RequestMapper;
import org.apache.nifi.processors.opentelemetry.encoding.ResponseBodyWriter;
import org.apache.nifi.processors.opentelemetry.encoding.StandardRequestMapper;
import org.apache.nifi.processors.opentelemetry.protocol.ServiceRequestDescription;
import org.apache.nifi.processors.opentelemetry.protocol.ServiceResponse;
import org.apache.nifi.processors.opentelemetry.protocol.ServiceResponseStatus;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryContentType;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryRequestType;

public class StandardResponseBodyWriter
implements ResponseBodyWriter {
    private static final String CAPACITY_ERROR_MESSAGE = "Queue capacity reached";
    private static final byte[] EMPTY_PROTOBUF_BODY = new byte[0];
    private static final byte[] EMPTY_JSON_OBJECT_BODY = new byte[]{123, 125};
    private static final RequestMapper REQUEST_MAPPER = new StandardRequestMapper();

    @Override
    public byte[] getResponseBody(ServiceRequestDescription serviceRequestDescription, ServiceResponse serviceResponse) {
        TelemetryContentType contentType;
        Objects.requireNonNull(serviceRequestDescription, "Request Description required");
        Objects.requireNonNull(serviceResponse, "Response required");
        ServiceResponseStatus serviceResponseStatus = serviceResponse.getServiceResponseStatus();
        byte[] responseBody = ServiceResponseStatus.PARTIAL_SUCCESS == serviceResponseStatus ? this.getPartialSuccessResponseBody(serviceRequestDescription, serviceResponse) : (TelemetryContentType.APPLICATION_JSON == (contentType = serviceRequestDescription.getContentType()) ? EMPTY_JSON_OBJECT_BODY : EMPTY_PROTOBUF_BODY);
        return responseBody;
    }

    private byte[] getPartialSuccessResponseBody(ServiceRequestDescription serviceRequestDescription, ServiceResponse serviceResponse) {
        byte[] responseBody;
        ExportLogsServiceResponse message;
        int rejected = serviceResponse.getRejected();
        TelemetryRequestType requestType = serviceRequestDescription.getRequestType();
        if (TelemetryRequestType.LOGS == requestType) {
            partialSuccess = ExportLogsPartialSuccess.newBuilder().setRejectedLogRecords((long)rejected).setErrorMessage(CAPACITY_ERROR_MESSAGE).build();
            message = ExportLogsServiceResponse.newBuilder().setPartialSuccess(partialSuccess).build();
        } else if (TelemetryRequestType.METRICS == requestType) {
            partialSuccess = ExportMetricsPartialSuccess.newBuilder().setRejectedDataPoints((long)rejected).setErrorMessage(CAPACITY_ERROR_MESSAGE).build();
            message = ExportMetricsServiceResponse.newBuilder().setPartialSuccess((ExportMetricsPartialSuccess)partialSuccess).build();
        } else if (TelemetryRequestType.TRACES == requestType) {
            partialSuccess = ExportTracePartialSuccess.newBuilder().setRejectedSpans((long)rejected).setErrorMessage(CAPACITY_ERROR_MESSAGE).build();
            message = ExportTraceServiceResponse.newBuilder().setPartialSuccess((ExportTracePartialSuccess)partialSuccess).build();
        } else {
            throw new IllegalArgumentException(String.format("Service Request Type [%s] not supported", new Object[]{requestType}));
        }
        TelemetryContentType contentType = serviceRequestDescription.getContentType();
        if (TelemetryContentType.APPLICATION_JSON == contentType) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                REQUEST_MAPPER.writeValue(outputStream, (Message)message);
                responseBody = outputStream.toByteArray();
            }
            catch (IOException e) {
                String error = String.format("JSON Response Type [%s] serialization failed", message.getClass().getName());
                throw new UncheckedIOException(error, e);
            }
        } else {
            responseBody = message.toByteArray();
        }
        return responseBody;
    }
}

