/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.protobuf.Message;
import com.hubspot.jackson.datatype.protobuf.MessageDeserializerFactory;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import org.apache.nifi.processors.opentelemetry.encoding.ByteStringFieldDeserializer;
import org.apache.nifi.processors.opentelemetry.encoding.HexadecimalMessageType;

public class StandardMessageDeserializerFactory
extends MessageDeserializerFactory {
    private final ProtobufJacksonConfig protobufJacksonConfig;

    public StandardMessageDeserializerFactory(ProtobufJacksonConfig protobufJacksonConfig) {
        super(protobufJacksonConfig);
        this.protobufJacksonConfig = protobufJacksonConfig;
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDescription) throws JsonMappingException {
        Class rawClass = type.getRawClass();
        if (this.isHexadecimalMessageType(rawClass)) {
            Class messageClass = rawClass;
            return new ByteStringFieldDeserializer(messageClass, this.protobufJacksonConfig).buildAtEnd();
        }
        return super.findBeanDeserializer(type, config, beanDescription);
    }

    private boolean isHexadecimalMessageType(Class<?> rawClass) {
        boolean found = false;
        for (HexadecimalMessageType hexadecimalMessageType : HexadecimalMessageType.values()) {
            Class<? extends Message> messageType = hexadecimalMessageType.getMessageType();
            if (!messageType.isAssignableFrom(rawClass)) continue;
            found = true;
            break;
        }
        return found;
    }
}

