/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mqtt.adapters;

import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5BlockingClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5WillPublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.mqtt.common.MqttClient;
import org.apache.nifi.processors.mqtt.common.MqttClientProperties;
import org.apache.nifi.processors.mqtt.common.MqttException;
import org.apache.nifi.processors.mqtt.common.MqttProtocolScheme;
import org.apache.nifi.processors.mqtt.common.ReceivedMqttMessage;
import org.apache.nifi.processors.mqtt.common.ReceivedMqttMessageHandler;
import org.apache.nifi.processors.mqtt.common.StandardMqttMessage;
import org.apache.nifi.security.ssl.StandardKeyManagerFactoryBuilder;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerFactoryBuilder;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;

public class HiveMqV5ClientAdapter
implements MqttClient {
    private final Mqtt5BlockingClient mqtt5BlockingClient;
    private final MqttClientProperties clientProperties;
    private final ComponentLog logger;

    public HiveMqV5ClientAdapter(URI brokerUri, MqttClientProperties clientProperties, ComponentLog logger) throws TlsException {
        this.mqtt5BlockingClient = HiveMqV5ClientAdapter.createClient(brokerUri, clientProperties, logger);
        this.clientProperties = clientProperties;
        this.logger = logger;
    }

    @Override
    public boolean isConnected() {
        return this.mqtt5BlockingClient.getState().isConnected();
    }

    @Override
    public void connect() {
        String lastWillTopic;
        this.logger.debug("Connecting to broker");
        Mqtt5ConnectBuilder connectBuilder = (Mqtt5ConnectBuilder)Mqtt5Connect.builder().keepAlive(this.clientProperties.getKeepAliveInterval());
        boolean cleanSession = this.clientProperties.isCleanSession();
        connectBuilder.cleanStart(cleanSession);
        if (!cleanSession) {
            connectBuilder.sessionExpiryInterval(this.clientProperties.getSessionExpiryInterval().longValue());
        }
        if ((lastWillTopic = this.clientProperties.getLastWillTopic()) != null) {
            ((Mqtt5WillPublishBuilder.Nested.Complete)((Mqtt5WillPublishBuilder.Nested.Complete)((Mqtt5WillPublishBuilder.Nested.Complete)((Mqtt5WillPublishBuilder.Nested.Complete)connectBuilder.willPublish().topic(lastWillTopic)).payload(this.clientProperties.getLastWillMessage().getBytes())).retain(this.clientProperties.getLastWillRetain().booleanValue())).qos(MqttQos.fromCode((int)this.clientProperties.getLastWillQos()))).applyWillPublish();
        }
        String username = this.clientProperties.getUsername();
        String password = this.clientProperties.getPassword();
        if (username != null && password != null) {
            ((Mqtt5SimpleAuthBuilder.Nested.Complete)((Mqtt5SimpleAuthBuilder.Nested.Complete)connectBuilder.simpleAuth().username(this.clientProperties.getUsername())).password(password.getBytes(StandardCharsets.UTF_8))).applySimpleAuth();
        }
        Mqtt5Connect mqtt5Connect = connectBuilder.build();
        this.mqtt5BlockingClient.connect(mqtt5Connect);
    }

    @Override
    public void disconnect() {
        this.logger.debug("Disconnecting client");
        this.mqtt5BlockingClient.disconnect();
    }

    @Override
    public void close() {
    }

    @Override
    public void publish(String topic, StandardMqttMessage message) {
        this.logger.debug("Publishing message to {} with QoS: {}", new Object[]{topic, message.getQos()});
        ((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)this.mqtt5BlockingClient.publishWith().topic(topic)).payload(message.getPayload())).retain(message.isRetained())).qos(Objects.requireNonNull(MqttQos.fromCode((int)message.getQos())))).send();
    }

    @Override
    public void subscribe(String topicFilter, int qos, ReceivedMqttMessageHandler handler) {
        this.logger.debug("Subscribing to {} with QoS: {}", new Object[]{topicFilter, qos});
        CompletableFuture futureAck = ((Mqtt5AsyncClient.Mqtt5SubscribeAndCallbackBuilder.Start.Complete)((Mqtt5AsyncClient.Mqtt5SubscribeAndCallbackBuilder.Start.Complete)this.mqtt5BlockingClient.toAsync().subscribeWith().topicFilter(topicFilter)).qos(Objects.requireNonNull(MqttQos.fromCode((int)qos)))).callback(mqtt5Publish -> {
            ReceivedMqttMessage receivedMessage = new ReceivedMqttMessage(mqtt5Publish.getPayloadAsBytes(), mqtt5Publish.getQos().getCode(), mqtt5Publish.isRetain(), mqtt5Publish.getTopic().toString());
            handler.handleReceivedMessage(receivedMessage);
        }).send();
        try {
            Mqtt5SubAck ack = (Mqtt5SubAck)futureAck.get(this.clientProperties.getConnectionTimeout(), TimeUnit.SECONDS);
            this.logger.debug("Received mqtt5 subscribe ack: {}", new Object[]{ack});
        }
        catch (Exception e) {
            throw new MqttException("An error has occurred during sending subscribe message to broker", e);
        }
    }

    private static Mqtt5BlockingClient createClient(URI brokerUri, MqttClientProperties clientProperties, ComponentLog logger) throws TlsException {
        MqttProtocolScheme scheme;
        logger.debug("Creating Mqtt v5 client");
        Mqtt5ClientBuilder mqtt5ClientBuilder = (Mqtt5ClientBuilder)((Mqtt5ClientBuilder)Mqtt5Client.builder().identifier(clientProperties.getClientId())).serverHost(brokerUri.getHost());
        int port = brokerUri.getPort();
        if (port != -1) {
            mqtt5ClientBuilder.serverPort(port);
        }
        if (MqttProtocolScheme.WS.equals((Object)(scheme = MqttProtocolScheme.valueOf(brokerUri.getScheme().toUpperCase()))) || MqttProtocolScheme.WSS.equals((Object)scheme)) {
            mqtt5ClientBuilder.webSocketConfig().applyWebSocketConfig();
        }
        if (MqttProtocolScheme.SSL.equals((Object)scheme) || MqttProtocolScheme.WSS.equals((Object)scheme)) {
            FileInputStream inputStream;
            TlsConfiguration tlsConfiguration = clientProperties.getTlsConfiguration();
            if (tlsConfiguration.getTruststorePath() != null) {
                KeyStore trustStore;
                try {
                    inputStream = new FileInputStream(tlsConfiguration.getTruststorePath());
                    try {
                        trustStore = new StandardKeyStoreBuilder().type(tlsConfiguration.getTruststoreType().getType()).password(tlsConfiguration.getTruststorePassword().toCharArray()).inputStream((InputStream)inputStream).build();
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e) {
                    throw new TlsException("Trust Store loading failed", (Throwable)e);
                }
                TrustManagerFactory trustManagerFactory = new StandardTrustManagerFactoryBuilder().trustStore(trustStore).build();
                ((MqttClientSslConfigBuilder.Nested)mqtt5ClientBuilder.sslConfig().trustManagerFactory(trustManagerFactory)).applySslConfig();
            }
            if (tlsConfiguration.getKeystorePath() != null) {
                KeyStore keyStore;
                try {
                    inputStream = new FileInputStream(tlsConfiguration.getKeystorePath());
                    try {
                        keyStore = new StandardKeyStoreBuilder().type(tlsConfiguration.getKeystoreType().getType()).password(tlsConfiguration.getKeystorePassword().toCharArray()).inputStream((InputStream)inputStream).build();
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e) {
                    throw new TlsException("Key Store loading failed", (Throwable)e);
                }
                KeyManagerFactory keyManagerFactory = new StandardKeyManagerFactoryBuilder().keyStore(keyStore).keyPassword(tlsConfiguration.getFunctionalKeyPassword().toCharArray()).build();
                ((MqttClientSslConfigBuilder.Nested)mqtt5ClientBuilder.sslConfig().keyManagerFactory(keyManagerFactory)).applySslConfig();
            }
        }
        return mqtt5ClientBuilder.buildBlocking();
    }
}

