/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mqtt.adapters;

import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.mqtt.common.MqttClient;
import org.apache.nifi.processors.mqtt.common.MqttClientProperties;
import org.apache.nifi.processors.mqtt.common.ReceivedMqttMessage;
import org.apache.nifi.processors.mqtt.common.ReceivedMqttMessageHandler;
import org.apache.nifi.processors.mqtt.common.StandardMqttMessage;
import org.apache.nifi.security.util.TlsConfiguration;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class PahoMqttClientAdapter
implements MqttClient {
    public static final int DISCONNECT_TIMEOUT = 5000;
    private final IMqttClient client;
    private final MqttClientProperties clientProperties;
    private final ComponentLog logger;

    public PahoMqttClientAdapter(URI brokerUri, MqttClientProperties clientProperties, ComponentLog logger) {
        this.client = PahoMqttClientAdapter.createClient(brokerUri, clientProperties, logger);
        this.clientProperties = clientProperties;
        this.logger = logger;
        this.client.setCallback((MqttCallback)new DefaultMqttCallback());
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public void connect() {
        this.logger.debug("Connecting to broker");
        try {
            String username;
            String lastWillTopic;
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setCleanSession(this.clientProperties.isCleanSession());
            connectOptions.setKeepAliveInterval(this.clientProperties.getKeepAliveInterval());
            connectOptions.setMqttVersion(this.clientProperties.getMqttVersion().getVersionCode());
            connectOptions.setConnectionTimeout(this.clientProperties.getConnectionTimeout());
            TlsConfiguration tlsConfiguration = this.clientProperties.getTlsConfiguration();
            if (tlsConfiguration != null) {
                connectOptions.setSSLProperties(PahoMqttClientAdapter.transformSSLContextService(tlsConfiguration));
            }
            if ((lastWillTopic = this.clientProperties.getLastWillTopic()) != null) {
                boolean lastWillRetain = this.clientProperties.getLastWillRetain() != null && this.clientProperties.getLastWillRetain() != false;
                connectOptions.setWill(lastWillTopic, this.clientProperties.getLastWillMessage().getBytes(), this.clientProperties.getLastWillQos().intValue(), lastWillRetain);
            }
            if ((username = this.clientProperties.getUsername()) != null) {
                connectOptions.setUserName(username);
                connectOptions.setPassword(this.clientProperties.getPassword().toCharArray());
            }
            this.client.connect(connectOptions);
        }
        catch (MqttException e) {
            throw new org.apache.nifi.processors.mqtt.common.MqttException("An error has occurred during connecting to broker", e);
        }
    }

    @Override
    public void disconnect() {
        this.logger.debug("Disconnecting client with timeout: {}", new Object[]{5000});
        try {
            this.client.disconnect(5000L);
        }
        catch (MqttException e) {
            throw new org.apache.nifi.processors.mqtt.common.MqttException("An error has occurred during disconnecting client with timeout: 5000", e);
        }
    }

    @Override
    public void close() {
        this.logger.debug("Closing client");
        try {
            this.client.close();
        }
        catch (MqttException e) {
            throw new org.apache.nifi.processors.mqtt.common.MqttException("An error has occurred during closing client", e);
        }
    }

    @Override
    public void publish(String topic, StandardMqttMessage message) {
        this.logger.debug("Publishing message to {} with QoS: {}", new Object[]{topic, message.getQos()});
        try {
            this.client.publish(topic, message.getPayload(), message.getQos(), message.isRetained());
        }
        catch (MqttException e) {
            throw new org.apache.nifi.processors.mqtt.common.MqttException("An error has occurred during publishing message to " + topic + " with QoS: " + message.getQos(), e);
        }
    }

    @Override
    public void subscribe(String topicFilter, int qos, ReceivedMqttMessageHandler handler) {
        this.logger.debug("Subscribing to {} with QoS: {}", new Object[]{topicFilter, qos});
        this.client.setCallback((MqttCallback)new ConsumerMqttCallback(handler));
        try {
            this.client.subscribe(topicFilter, qos);
        }
        catch (MqttException e) {
            throw new org.apache.nifi.processors.mqtt.common.MqttException("An error has occurred during subscribing to " + topicFilter + " with QoS: " + qos, e);
        }
    }

    public static Properties transformSSLContextService(TlsConfiguration tlsConfiguration) {
        Properties properties = new Properties();
        if (tlsConfiguration.getProtocol() != null) {
            properties.setProperty("com.ibm.ssl.protocol", tlsConfiguration.getProtocol());
        }
        if (tlsConfiguration.getKeystorePath() != null) {
            properties.setProperty("com.ibm.ssl.keyStore", tlsConfiguration.getKeystorePath());
        }
        if (tlsConfiguration.getKeystorePassword() != null) {
            properties.setProperty("com.ibm.ssl.keyStorePassword", tlsConfiguration.getKeystorePassword());
        }
        if (tlsConfiguration.getKeystoreType() != null) {
            properties.setProperty("com.ibm.ssl.keyStoreType", tlsConfiguration.getKeystoreType().getType());
        }
        if (tlsConfiguration.getTruststorePath() != null) {
            properties.setProperty("com.ibm.ssl.trustStore", tlsConfiguration.getTruststorePath());
        }
        if (tlsConfiguration.getTruststorePassword() != null) {
            properties.setProperty("com.ibm.ssl.trustStorePassword", tlsConfiguration.getTruststorePassword());
        }
        if (tlsConfiguration.getTruststoreType() != null) {
            properties.setProperty("com.ibm.ssl.trustStoreType", tlsConfiguration.getTruststoreType().getType());
        }
        return properties;
    }

    private static org.eclipse.paho.client.mqttv3.MqttClient createClient(URI brokerUri, MqttClientProperties clientProperties, ComponentLog logger) {
        logger.debug("Creating Mqtt v3 client");
        try {
            return new org.eclipse.paho.client.mqttv3.MqttClient(brokerUri.toString(), clientProperties.getClientId(), (MqttClientPersistence)new MemoryPersistence());
        }
        catch (MqttException e) {
            throw new org.apache.nifi.processors.mqtt.common.MqttException("An error has occurred during creating adapter for MQTT v3 client", e);
        }
    }

    private class DefaultMqttCallback
    implements MqttCallback {
        private DefaultMqttCallback() {
        }

        public void connectionLost(Throwable cause) {
            PahoMqttClientAdapter.this.logger.error("Connection to [{}] lost", new Object[]{PahoMqttClientAdapter.this.clientProperties.getRawBrokerUris(), cause});
        }

        public void messageArrived(String topic, MqttMessage message) {
            PahoMqttClientAdapter.this.logger.error("MQTT message arrived [topic:{}; payload:{}]", new Object[]{topic, Arrays.toString(message.getPayload())});
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
            PahoMqttClientAdapter.this.logger.trace("Received 'delivery complete' message from broker. Token: [{}]", new Object[]{token});
        }
    }

    private class ConsumerMqttCallback
    extends DefaultMqttCallback {
        private final ReceivedMqttMessageHandler handler;

        private ConsumerMqttCallback(ReceivedMqttMessageHandler handler) {
            this.handler = handler;
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) {
            PahoMqttClientAdapter.this.logger.debug("Message arrived. Id: [{}]", new Object[]{message.getId()});
            ReceivedMqttMessage receivedMessage = new ReceivedMqttMessage(message.getPayload(), message.getQos(), message.isRetained(), topic);
            this.handler.handleReceivedMessage(receivedMessage);
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken token) {
            PahoMqttClientAdapter.this.logger.error("Received MQTT 'delivery complete' message to a subscribed client. Token: [{}]", new Object[]{token});
        }
    }
}

