/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockProcessContext;

public class MockPropertyValue
implements PropertyValue {
    private final String rawValue;
    private final Boolean expectExpressions;
    private final ExpressionLanguageScope expressionLanguageScope;
    private final MockControllerServiceLookup serviceLookup;
    private final PropertyDescriptor propertyDescriptor;
    private final PropertyValue stdPropValue;
    private Map<String, String> environmentVariables;
    private boolean expressionsEvaluated;

    public MockPropertyValue(String rawValue) {
        this(rawValue, null, null);
    }

    public MockPropertyValue(String rawValue, Map<String, String> environmentVariables) {
        this(rawValue, null, environmentVariables);
    }

    public MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, Map<String, String> environmentVariables) {
        this(rawValue, serviceLookup, null, environmentVariables);
    }

    public MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, Map<String, String> environmentVariables, ParameterLookup parameterLookup) {
        this(rawValue, serviceLookup, null, false, environmentVariables, parameterLookup);
    }

    public MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, PropertyDescriptor propertyDescriptor, Map<String, String> environmentVariables) {
        this(rawValue, serviceLookup, propertyDescriptor, false, environmentVariables);
    }

    protected MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, PropertyDescriptor propertyDescriptor, boolean alreadyEvaluated, Map<String, String> environmentVariables) {
        this(rawValue, serviceLookup, propertyDescriptor, alreadyEvaluated, environmentVariables, ParameterLookup.EMPTY);
    }

    protected MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, PropertyDescriptor propertyDescriptor, boolean alreadyEvaluated, Map<String, String> environmentVariables, ParameterLookup parameterLookup) {
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), propertyDescriptor);
        this.stdPropValue = new StandardPropertyValue((ResourceContext)resourceContext, rawValue, serviceLookup, parameterLookup);
        this.rawValue = rawValue;
        this.serviceLookup = (MockControllerServiceLookup)serviceLookup;
        this.expectExpressions = propertyDescriptor == null ? null : Boolean.valueOf(propertyDescriptor.isExpressionLanguageSupported());
        this.expressionLanguageScope = propertyDescriptor == null ? null : propertyDescriptor.getExpressionLanguageScope();
        this.propertyDescriptor = propertyDescriptor;
        this.expressionsEvaluated = alreadyEvaluated;
        this.environmentVariables = environmentVariables;
    }

    private void ensureExpressionsEvaluated() {
        if (Boolean.TRUE.equals(this.expectExpressions) && !this.expressionsEvaluated) {
            throw new IllegalStateException("Attempting to retrieve value of " + String.valueOf(this.propertyDescriptor) + " without first evaluating Expressions, even though the PropertyDescriptor indicates that the Expression Language is Supported. If you realize that this is the case and do not want this error to occur, it can be disabled by calling TestRunner.setValidateExpressionUsage(false)");
        }
    }

    private void validateExpressionScope(boolean flowFileProvided, boolean additionalAttributesAvailable) {
        if (this.expressionLanguageScope == null) {
            return;
        }
        if (flowFileProvided && !ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope)) {
            throw new IllegalStateException("Attempting to evaluate expression language for " + this.propertyDescriptor.getName() + " using flow file attributes but the scope evaluation is set to " + String.valueOf(this.expressionLanguageScope) + ". The proper scope should be set in the property descriptor using PropertyDescriptor.Builder.expressionLanguageSupported(ExpressionLanguageScope)");
        }
        if (ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope) && (this.serviceLookup.getInputRequirement() == null || this.serviceLookup.getInputRequirement().value().equals((Object)InputRequirement.Requirement.INPUT_FORBIDDEN))) {
            return;
        }
        if (ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope) && !((MockProcessContext)this.serviceLookup).hasIncomingConnection()) {
            return;
        }
        if (!flowFileProvided && !additionalAttributesAvailable && ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope)) {
            throw new IllegalStateException("Attempting to evaluate expression language for " + this.propertyDescriptor.getName() + " without using flow file attributes but the scope evaluation is set to " + String.valueOf(this.expressionLanguageScope) + ". The proper scope should be set in the property descriptor using PropertyDescriptor.Builder.expressionLanguageSupported(ExpressionLanguageScope)");
        }
    }

    public String getValue() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.getValue();
    }

    public Integer asInteger() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asInteger();
    }

    public Long asLong() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asLong();
    }

    public Boolean asBoolean() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asBoolean();
    }

    public Float asFloat() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asFloat();
    }

    public Double asDouble() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asDouble();
    }

    public Long asTimePeriod(TimeUnit timeUnit) {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asTimePeriod(timeUnit);
    }

    public Duration asDuration() {
        return this.isSet() ? Duration.ofNanos(this.asTimePeriod(TimeUnit.NANOSECONDS)) : null;
    }

    public Double asDataSize(DataUnit dataUnit) {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asDataSize(dataUnit);
    }

    private void markEvaluated() {
        if (this.expressionsEvaluated) {
            return;
        }
        if (Boolean.FALSE.equals(this.expectExpressions)) {
            throw new IllegalStateException("Attempting to Evaluate Expressions but " + String.valueOf(this.propertyDescriptor) + " is not a supported property, or the property indicates that the Expression Language is not supported. If you realize that this is the case and do not want this error to occur, it can be disabled by calling TestRunner.setValidateExpressionUsage(false)");
        }
        this.expressionsEvaluated = true;
    }

    public PropertyValue evaluateAttributeExpressions() throws ProcessException {
        return this.evaluateAttributeExpressions(null, null, null);
    }

    public PropertyValue evaluateAttributeExpressions(AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(null, null, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile) throws ProcessException {
        if (flowFile == null && this.expressionLanguageScope == ExpressionLanguageScope.FLOWFILE_ATTRIBUTES) {
            return this.evaluateAttributeExpressions(new HashMap<String, String>());
        }
        if (flowFile == null && this.expressionLanguageScope == ExpressionLanguageScope.ENVIRONMENT) {
            return this.evaluateAttributeExpressions();
        }
        return this.evaluateAttributeExpressions(flowFile, null, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, null, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, additionalAttributes, null);
    }

    public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes) throws ProcessException {
        return this.evaluateAttributeExpressions(null, attributes, null);
    }

    public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(null, attributes, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, additionalAttributes, decorator, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator, Map<String, String> stateValues) throws ProcessException {
        boolean alreadyValidated = this.expressionsEvaluated;
        this.markEvaluated();
        if (this.rawValue == null) {
            return this;
        }
        if (!alreadyValidated) {
            this.validateExpressionScope(flowFile != null, additionalAttributes != null);
        }
        if (additionalAttributes == null) {
            additionalAttributes = new HashMap<String, String>();
        }
        HashMap<String, String> attAndEnvVarRegistry = new HashMap<String, String>(additionalAttributes);
        if (this.environmentVariables != null) {
            attAndEnvVarRegistry.putAll(this.environmentVariables);
        }
        PropertyValue newValue = this.stdPropValue.evaluateAttributeExpressions(flowFile, attAndEnvVarRegistry, decorator, stateValues);
        return new MockPropertyValue(newValue.getValue(), this.serviceLookup, this.propertyDescriptor, true, this.environmentVariables);
    }

    public ControllerService asControllerService() {
        this.ensureExpressionsEvaluated();
        if (this.rawValue == null || this.rawValue.equals("")) {
            return null;
        }
        return this.serviceLookup.getControllerService(this.rawValue);
    }

    public <T extends ControllerService> T asControllerService(Class<T> serviceType) throws IllegalArgumentException {
        this.ensureExpressionsEvaluated();
        if (this.rawValue == null || this.rawValue.equals("")) {
            return null;
        }
        ControllerService service = this.serviceLookup.getControllerService(this.rawValue);
        if (serviceType.isAssignableFrom(service.getClass())) {
            return (T)((ControllerService)serviceType.cast(service));
        }
        throw new IllegalArgumentException("Controller Service with identifier " + this.rawValue + " is of type " + String.valueOf(service.getClass()) + " and cannot be cast to " + String.valueOf(serviceType));
    }

    public ResourceReference asResource() {
        if (this.propertyDescriptor == null) {
            return null;
        }
        return new StandardResourceReferenceFactory().createResourceReference(this.rawValue, this.propertyDescriptor.getResourceDefinition());
    }

    public ResourceReferences asResources() {
        if (this.propertyDescriptor == null) {
            return null;
        }
        return new StandardResourceReferenceFactory().createResourceReferences(this.rawValue, this.propertyDescriptor.getResourceDefinition());
    }

    public <E extends Enum<E>> E asAllowableValue(Class<E> enumType) throws IllegalArgumentException {
        this.ensureExpressionsEvaluated();
        return (E)this.stdPropValue.asAllowableValue(enumType);
    }

    public boolean isSet() {
        return this.rawValue != null;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean isExpressionLanguagePresent() {
        if (this.rawValue == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.rawValue);
        return elRanges != null && !elRanges.isEmpty();
    }
}

