/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.util.PropertyMigrationResult;

public class MockPropertyConfiguration
implements PropertyConfiguration {
    private final Map<String, String> propertyRenames = new HashMap<String, String>();
    private final Set<String> propertiesRemoved = new HashSet<String>();
    private final Set<String> propertiesUpdated = new HashSet<String>();
    private final Map<String, String> rawProperties;
    private final Set<CreatedControllerService> createdControllerServices = new HashSet<CreatedControllerService>();

    public MockPropertyConfiguration(Map<String, String> propertyValues) {
        this.rawProperties = new HashMap<String, String>(propertyValues);
    }

    public PropertyMigrationResult toPropertyMigrationResult() {
        return new PropertyMigrationResult(){

            @Override
            public Set<String> getPropertiesRemoved() {
                return Collections.unmodifiableSet(MockPropertyConfiguration.this.propertiesRemoved);
            }

            @Override
            public Map<String, String> getPropertiesRenamed() {
                return Collections.unmodifiableMap(MockPropertyConfiguration.this.propertyRenames);
            }

            @Override
            public Set<CreatedControllerService> getCreatedControllerServices() {
                return Collections.unmodifiableSet(MockPropertyConfiguration.this.createdControllerServices);
            }

            @Override
            public Set<String> getPropertiesUpdated() {
                return Collections.unmodifiableSet(MockPropertyConfiguration.this.propertiesUpdated);
            }
        };
    }

    public boolean renameProperty(String propertyName, String newName) {
        this.propertyRenames.put(propertyName, newName);
        boolean hasProperty = this.hasProperty(propertyName);
        if (!hasProperty) {
            return false;
        }
        String value = this.rawProperties.remove(propertyName);
        this.rawProperties.put(newName, value);
        return true;
    }

    public boolean removeProperty(String propertyName) {
        this.propertiesRemoved.add(propertyName);
        if (!this.hasProperty(propertyName)) {
            return false;
        }
        this.rawProperties.remove(propertyName);
        return true;
    }

    public boolean hasProperty(String propertyName) {
        return this.rawProperties.containsKey(propertyName);
    }

    public boolean isPropertySet(String propertyName) {
        return this.rawProperties.get(propertyName) != null;
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.propertiesUpdated.add(propertyName);
        this.rawProperties.put(propertyName, propertyValue);
    }

    public Optional<String> getPropertyValue(String propertyName) {
        return this.getRawPropertyValue(propertyName);
    }

    public Optional<String> getRawPropertyValue(String propertyName) {
        return Optional.ofNullable(this.rawProperties.get(propertyName));
    }

    public Map<String, String> getProperties() {
        return this.getRawProperties();
    }

    public Map<String, String> getRawProperties() {
        return Collections.unmodifiableMap(this.rawProperties);
    }

    public String createControllerService(String implementationClassName, Map<String, String> serviceProperties) {
        String serviceId = UUID.randomUUID().toString();
        this.createdControllerServices.add(new CreatedControllerService(serviceId, implementationClassName, serviceProperties));
        return serviceId;
    }

    public record CreatedControllerService(String id, String implementationClassName, Map<String, String> serviceProperties) {
    }
}

