/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterLookup;

public class MockParameterLookup
implements ParameterLookup {
    private final Map<String, String> parameters;
    private final AtomicLong version = new AtomicLong(1L);

    public MockParameterLookup(Map<String, String> parameters) {
        this.parameters = parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(parameters);
    }

    public Optional<Parameter> getParameter(String parameterName) {
        String value = this.parameters.get(parameterName);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new Parameter.Builder().name(parameterName).value(value).build());
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public long getVersion() {
        return this.version.get();
    }
}

