/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;

public class MockProvenanceEvent
implements ProvenanceEventRecord {
    private final long eventTime;
    private final long entryDate;
    private final ProvenanceEventType eventType;
    private final long lineageStartDate;
    private final String componentId;
    private final String componentType;
    private final String transitUri;
    private final String sourceSystemFlowFileIdentifier;
    private final String uuid;
    private final List<String> parentUuids;
    private final List<String> childrenUuids;
    private final String alternateIdentifierUri;
    private final String details;
    private final String relationship;
    private final long eventDuration;
    private final String contentClaimSection;
    private final String contentClaimContainer;
    private final String contentClaimIdentifier;
    private final Long contentClaimOffset;
    private final long contentSize;
    private final String previousClaimSection;
    private final String previousClaimContainer;
    private final String previousClaimIdentifier;
    private final Long previousClaimOffset;
    private final Long previousSize;
    private final String sourceQueueIdentifier;
    private final Map<String, String> previousAttributes;
    private final Map<String, String> updatedAttributes;
    private volatile long eventId = -1L;

    private MockProvenanceEvent(Builder builder) {
        this.eventTime = builder.eventTime;
        this.entryDate = builder.entryDate;
        this.eventType = builder.eventType;
        this.componentId = builder.componentId;
        this.componentType = builder.componentType;
        this.transitUri = builder.transitUri;
        this.sourceSystemFlowFileIdentifier = builder.sourceSystemFlowFileIdentifier;
        this.uuid = builder.uuid;
        this.parentUuids = builder.parentUuids;
        this.childrenUuids = builder.childrenUuids;
        this.alternateIdentifierUri = builder.alternateIdentifierUri;
        this.details = builder.details;
        this.relationship = builder.relationship;
        this.eventDuration = builder.eventDuration;
        this.lineageStartDate = builder.lineageStartDate;
        this.previousClaimSection = builder.previousClaimSection;
        this.previousClaimContainer = builder.previousClaimContainer;
        this.previousClaimIdentifier = builder.previousClaimIdentifier;
        this.previousClaimOffset = builder.previousClaimOffset;
        this.previousSize = builder.previousSize;
        this.contentClaimSection = builder.contentClaimSection;
        this.contentClaimContainer = builder.contentClaimContainer;
        this.contentClaimIdentifier = builder.contentClaimIdentifier;
        this.contentClaimOffset = builder.contentClaimOffset;
        this.contentSize = builder.contentSize;
        this.previousAttributes = builder.previousAttributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.previousAttributes);
        this.updatedAttributes = builder.updatedAttributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.updatedAttributes);
        this.sourceQueueIdentifier = builder.sourceQueueIdentifier;
        if (builder.eventId != null) {
            this.eventId = builder.eventId;
        }
    }

    void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public long getEventId() {
        return this.eventId;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public long getLineageStartDate() {
        return this.lineageStartDate;
    }

    public long getFileSize() {
        return this.contentSize;
    }

    public Long getPreviousFileSize() {
        return this.previousSize;
    }

    public ProvenanceEventType getEventType() {
        return this.eventType;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> allAttrs = new HashMap<String, String>(this.previousAttributes.size() + this.updatedAttributes.size());
        allAttrs.putAll(this.previousAttributes);
        for (Map.Entry<String, String> entry : this.updatedAttributes.entrySet()) {
            if (entry.getValue() == null) continue;
            allAttrs.put(entry.getKey(), entry.getValue());
        }
        return allAttrs;
    }

    public String getAttribute(String attributeName) {
        if (this.updatedAttributes.containsKey(attributeName)) {
            return this.updatedAttributes.get(attributeName);
        }
        return this.previousAttributes.get(attributeName);
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getTransitUri() {
        return this.transitUri;
    }

    public String getSourceSystemFlowFileIdentifier() {
        return this.sourceSystemFlowFileIdentifier;
    }

    public String getFlowFileUuid() {
        return this.uuid;
    }

    public List<String> getParentUuids() {
        return this.parentUuids == null ? Collections.emptyList() : this.parentUuids;
    }

    public List<String> getChildUuids() {
        return this.childrenUuids == null ? Collections.emptyList() : this.childrenUuids;
    }

    public String getAlternateIdentifierUri() {
        return this.alternateIdentifierUri;
    }

    public long getEventDuration() {
        return this.eventDuration;
    }

    public String getDetails() {
        return this.details;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public long getFlowFileEntryDate() {
        return this.entryDate;
    }

    public String getContentClaimSection() {
        return this.contentClaimSection;
    }

    public String getContentClaimContainer() {
        return this.contentClaimContainer;
    }

    public String getContentClaimIdentifier() {
        return this.contentClaimIdentifier;
    }

    public Long getContentClaimOffset() {
        return this.contentClaimOffset;
    }

    public String getSourceQueueIdentifier() {
        return this.sourceQueueIdentifier;
    }

    public Map<String, String> getPreviousAttributes() {
        return this.previousAttributes;
    }

    public String getPreviousContentClaimContainer() {
        return this.previousClaimContainer;
    }

    public String getPreviousContentClaimIdentifier() {
        return this.previousClaimIdentifier;
    }

    public Long getPreviousContentClaimOffset() {
        return this.previousClaimOffset;
    }

    public String getPreviousContentClaimSection() {
        return this.previousClaimSection;
    }

    public Map<String, String> getUpdatedAttributes() {
        return this.updatedAttributes;
    }

    public int hashCode() {
        int eventTypeCode = this.eventType == ProvenanceEventType.CLONE || this.eventType == ProvenanceEventType.JOIN || this.eventType == ProvenanceEventType.FORK ? 1472 : (this.eventType == ProvenanceEventType.REPLAY ? 21479 + (int)(Integer.MAX_VALUE & this.eventTime) : 4812 + this.eventType.hashCode() + 4 * this.uuid.hashCode());
        return -37423 + 3 * this.componentId.hashCode() + (this.transitUri == null ? 0 : 41 * this.transitUri.hashCode()) + (this.relationship == null ? 0 : 47 * this.relationship.hashCode()) + 44 * eventTypeCode + 47 * this.getChildUuids().hashCode() + 47 * this.getParentUuids().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MockProvenanceEvent)) {
            return false;
        }
        MockProvenanceEvent other = (MockProvenanceEvent)obj;
        if (this.eventId > 0L && other.getEventId() > 0L && this.eventId != other.getEventId()) {
            return false;
        }
        if (this.eventType != other.eventType) {
            return false;
        }
        if (!this.componentId.equals(other.componentId)) {
            return false;
        }
        if (this.different(this.parentUuids, other.parentUuids)) {
            return false;
        }
        if (this.different(this.childrenUuids, other.childrenUuids)) {
            return false;
        }
        if (!this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.different(this.transitUri, other.transitUri)) {
            return false;
        }
        if (this.different(this.relationship, other.relationship)) {
            return false;
        }
        return this.eventType != ProvenanceEventType.REPLAY || this.eventTime == other.getEventTime();
    }

    private boolean different(Object a, Object b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return !a.equals(b);
    }

    private boolean different(List<String> a, List<String> b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null && !b.isEmpty()) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (!a.isEmpty() && b == null) {
            return true;
        }
        if (a.isEmpty() && b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return true;
        }
        ArrayList<String> sortedA = new ArrayList<String>(a);
        ArrayList<String> sortedB = new ArrayList<String>(b);
        Collections.sort(sortedA);
        Collections.sort(sortedB);
        for (int i = 0; i < sortedA.size(); ++i) {
            if (((String)sortedA.get(i)).equals(sortedB.get(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ProvenanceEventRecord [eventId=" + this.eventId + ", eventType=" + String.valueOf(this.eventType) + ", eventTime=" + String.valueOf(new Date(this.eventTime)) + ", uuid=" + this.uuid + ", fileSize=" + this.contentSize + ", componentId=" + this.componentId + ", transitUri=" + this.transitUri + ", sourceSystemFlowFileIdentifier=" + this.sourceSystemFlowFileIdentifier + ", parentUuids=" + String.valueOf(this.parentUuids) + ", alternateIdentifierUri=" + this.alternateIdentifierUri + "]";
    }

    public String getBestEventIdentifier() {
        if (this.getEventId() != -1L) {
            return Long.toString(this.getEventId());
        }
        return this.getEventType().name() + "_on_" + this.getFlowFileUuid() + "_by_" + this.getComponentId() + "_at_" + this.getEventTime();
    }

    public static class Builder
    implements ProvenanceEventBuilder {
        private static final AtomicLong eventIdGenerator = new AtomicLong(0L);
        private long eventTime = System.currentTimeMillis();
        private long entryDate;
        private long lineageStartDate;
        private ProvenanceEventType eventType = null;
        private String componentId = null;
        private String componentType = null;
        private String sourceSystemFlowFileIdentifier = null;
        private String transitUri = null;
        private String uuid = null;
        private List<String> parentUuids = null;
        private List<String> childrenUuids = null;
        private String alternateIdentifierUri = null;
        private String details = null;
        private String relationship = null;
        private long eventDuration = -1L;
        private Long eventId = eventIdGenerator.getAndIncrement();
        private String contentClaimSection;
        private String contentClaimContainer;
        private String contentClaimIdentifier;
        private Long contentClaimOffset;
        private Long contentSize;
        private String previousClaimSection;
        private String previousClaimContainer;
        private String previousClaimIdentifier;
        private Long previousClaimOffset;
        private Long previousSize;
        private String sourceQueueIdentifier;
        private Map<String, String> previousAttributes;
        private Map<String, String> updatedAttributes;

        public Builder fromEvent(ProvenanceEventRecord event) {
            this.eventTime = event.getEventTime();
            this.entryDate = event.getFlowFileEntryDate();
            this.lineageStartDate = event.getLineageStartDate();
            this.eventType = event.getEventType();
            this.componentId = event.getComponentId();
            this.componentType = event.getComponentType();
            this.transitUri = event.getTransitUri();
            this.sourceSystemFlowFileIdentifier = event.getSourceSystemFlowFileIdentifier();
            this.uuid = event.getFlowFileUuid();
            this.parentUuids = event.getParentUuids();
            this.childrenUuids = event.getChildUuids();
            this.alternateIdentifierUri = event.getAlternateIdentifierUri();
            this.eventDuration = event.getEventDuration();
            this.previousAttributes = event.getPreviousAttributes();
            this.updatedAttributes = event.getUpdatedAttributes();
            this.details = event.getDetails();
            this.relationship = event.getRelationship();
            this.contentClaimSection = event.getContentClaimSection();
            this.contentClaimContainer = event.getContentClaimContainer();
            this.contentClaimIdentifier = event.getContentClaimIdentifier();
            this.contentClaimOffset = event.getContentClaimOffset();
            this.contentSize = event.getFileSize();
            this.previousClaimSection = event.getPreviousContentClaimSection();
            this.previousClaimContainer = event.getPreviousContentClaimContainer();
            this.previousClaimIdentifier = event.getPreviousContentClaimIdentifier();
            this.previousClaimOffset = event.getPreviousContentClaimOffset();
            this.previousSize = event.getPreviousFileSize();
            this.sourceQueueIdentifier = event.getSourceQueueIdentifier();
            return this;
        }

        public Builder setEventId(long eventId) {
            this.eventId = eventId;
            return this;
        }

        public ProvenanceEventBuilder copy() {
            Builder copy = new Builder();
            copy.eventTime = this.eventTime;
            copy.entryDate = this.entryDate;
            copy.lineageStartDate = this.lineageStartDate;
            copy.eventType = this.eventType;
            copy.componentId = this.componentId;
            copy.componentType = this.componentType;
            copy.transitUri = this.transitUri;
            copy.sourceSystemFlowFileIdentifier = this.sourceSystemFlowFileIdentifier;
            copy.uuid = this.uuid;
            if (this.parentUuids != null) {
                copy.parentUuids = new ArrayList<String>(this.parentUuids);
            }
            if (this.childrenUuids != null) {
                copy.childrenUuids = new ArrayList<String>(this.childrenUuids);
            }
            copy.alternateIdentifierUri = this.alternateIdentifierUri;
            copy.eventDuration = this.eventDuration;
            if (this.previousAttributes != null) {
                copy.previousAttributes = new HashMap<String, String>(this.previousAttributes);
            }
            if (this.updatedAttributes != null) {
                copy.updatedAttributes = new HashMap<String, String>(this.updatedAttributes);
            }
            copy.details = this.details;
            copy.relationship = this.relationship;
            copy.contentClaimContainer = this.contentClaimContainer;
            copy.contentClaimSection = this.contentClaimSection;
            copy.contentClaimIdentifier = this.contentClaimIdentifier;
            copy.contentClaimOffset = this.contentClaimOffset;
            copy.contentSize = this.contentSize;
            copy.previousClaimContainer = this.previousClaimContainer;
            copy.previousClaimSection = this.previousClaimSection;
            copy.previousClaimIdentifier = this.previousClaimIdentifier;
            copy.previousClaimOffset = this.previousClaimOffset;
            copy.previousSize = this.previousSize;
            copy.sourceQueueIdentifier = this.sourceQueueIdentifier;
            return copy;
        }

        public Builder setFlowFileEntryDate(long entryDate) {
            this.entryDate = entryDate;
            return this;
        }

        public Builder setAttributes(Map<String, String> previousAttributes, Map<String, String> updatedAttributes) {
            this.previousAttributes = previousAttributes;
            this.updatedAttributes = updatedAttributes;
            return this;
        }

        public Builder setUpdatedAttributes(Map<String, String> updatedAttributes) {
            this.updatedAttributes = updatedAttributes;
            return this;
        }

        public Builder setFlowFileUUID(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setEventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public Builder setEventDuration(long millis) {
            this.eventDuration = millis;
            return this;
        }

        public Builder setLineageStartDate(long startDate) {
            this.lineageStartDate = startDate;
            return this;
        }

        public Builder setEventType(ProvenanceEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder setComponentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public Builder setComponentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public Builder setSourceSystemFlowFileIdentifier(String sourceSystemFlowFileIdentifier) {
            this.sourceSystemFlowFileIdentifier = sourceSystemFlowFileIdentifier;
            return this;
        }

        public Builder setTransitUri(String transitUri) {
            this.transitUri = transitUri;
            return this;
        }

        public Builder addParentFlowFile(FlowFile parentFlowFile) {
            if (this.parentUuids == null) {
                this.parentUuids = new ArrayList<String>();
            }
            this.parentUuids.add(parentFlowFile.getAttribute(CoreAttributes.UUID.key()));
            return this;
        }

        public Builder removeParentFlowFile(FlowFile parentFlowFile) {
            if (this.parentUuids == null) {
                return this;
            }
            this.parentUuids.remove(parentFlowFile.getAttribute(CoreAttributes.UUID.key()));
            return this;
        }

        public Builder addChildFlowFile(FlowFile childFlowFile) {
            return this.addChildFlowFile(childFlowFile.getAttribute(CoreAttributes.UUID.key()));
        }

        public Builder addChildFlowFile(String childId) {
            if (this.childrenUuids == null) {
                this.childrenUuids = new ArrayList<String>();
            }
            this.childrenUuids.add(childId);
            return this;
        }

        public Builder removeChildFlowFile(FlowFile childFlowFile) {
            if (this.childrenUuids == null) {
                return this;
            }
            this.childrenUuids.remove(childFlowFile.getAttribute(CoreAttributes.UUID.key()));
            return this;
        }

        public Builder setAlternateIdentifierUri(String alternateIdentifierUri) {
            this.alternateIdentifierUri = alternateIdentifierUri;
            return this;
        }

        public Builder setDetails(String details) {
            this.details = details;
            return this;
        }

        public Builder setRelationship(Relationship relationship) {
            this.relationship = relationship.getName();
            return this;
        }

        public Builder setRelationship(String relationship) {
            this.relationship = relationship;
            return this;
        }

        public ProvenanceEventBuilder fromFlowFile(FlowFile flowFile) {
            this.setFlowFileEntryDate(flowFile.getEntryDate());
            this.setLineageStartDate(flowFile.getLineageStartDate());
            this.setAttributes(Collections.emptyMap(), flowFile.getAttributes());
            this.uuid = flowFile.getAttribute(CoreAttributes.UUID.key());
            this.contentSize = flowFile.getSize();
            return this;
        }

        public Builder setPreviousContentClaim(String container, String section, String identifier, Long offset, long size) {
            this.previousClaimSection = section;
            this.previousClaimContainer = container;
            this.previousClaimIdentifier = identifier;
            this.previousClaimOffset = offset;
            this.previousSize = size;
            return this;
        }

        public Builder setCurrentContentClaim(String container, String section, String identifier, Long offset, long size) {
            this.contentClaimSection = section;
            this.contentClaimContainer = container;
            this.contentClaimIdentifier = identifier;
            this.contentClaimOffset = offset;
            this.contentSize = size;
            return this;
        }

        public Builder setSourceQueueIdentifier(String identifier) {
            this.sourceQueueIdentifier = identifier;
            return this;
        }

        private void assertSet(Object value, String name) {
            if (value == null) {
                throw new IllegalStateException("Cannot create Provenance Event Record because " + name + " is not set");
            }
        }

        public ProvenanceEventType getEventType() {
            return this.eventType;
        }

        public List<String> getChildUuids() {
            return Collections.unmodifiableList(this.childrenUuids);
        }

        public List<String> getParentUuids() {
            return Collections.unmodifiableList(this.parentUuids);
        }

        public MockProvenanceEvent build() {
            this.assertSet(this.eventType, "Event Type");
            this.assertSet(this.componentId, "Component ID");
            this.assertSet(this.componentType, "Component Type");
            this.assertSet(this.uuid, "FlowFile UUID");
            this.assertSet(this.contentSize, "FlowFile Size");
            switch (this.eventType) {
                case ADDINFO: {
                    if (this.alternateIdentifierUri != null) break;
                    throw new IllegalStateException("Cannot create Provenance Event Record of type " + String.valueOf(this.eventType) + " because no alternate identifiers have been set");
                }
                case RECEIVE: 
                case FETCH: 
                case SEND: 
                case UPLOAD: {
                    this.assertSet(this.transitUri, "Transit URI");
                    break;
                }
                case ROUTE: {
                    this.assertSet(this.relationship, "Relationship");
                    break;
                }
                case CLONE: 
                case FORK: 
                case JOIN: {
                    if (this.parentUuids != null && !this.parentUuids.isEmpty() || this.childrenUuids != null && !this.childrenUuids.isEmpty()) break;
                    throw new IllegalStateException("Cannot create Provenance Event Record of type " + String.valueOf(this.eventType) + " because no Parent UUIDs or Children UUIDs have been set");
                }
            }
            return new MockProvenanceEvent(this);
        }

        public List<String> getChildFlowFileIds() {
            return this.childrenUuids;
        }

        public List<String> getParentFlowFileIds() {
            return this.parentUuids;
        }

        public String getFlowFileId() {
            return this.uuid;
        }
    }
}

