/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.kerberos.KerberosContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.RelationshipConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.registry.EnvironmentVariables;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.FlowFileValidator;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockConfigurationContext;
import org.apache.nifi.util.MockControllerServiceInitializationContext;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockFlowFileQueue;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.MockProcessSession;
import org.apache.nifi.util.MockProcessorInitializationContext;
import org.apache.nifi.util.MockPropertyConfiguration;
import org.apache.nifi.util.MockRelationshipConfiguration;
import org.apache.nifi.util.MockSessionFactory;
import org.apache.nifi.util.MockValidationContext;
import org.apache.nifi.util.PropertyMigrationResult;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.RelationshipMigrationResult;
import org.apache.nifi.util.SharedSessionState;
import org.apache.nifi.util.TestRunner;
import org.junit.jupiter.api.Assertions;

public class StandardProcessorTestRunner
implements TestRunner {
    private final Processor processor;
    private final MockProcessContext context;
    private final KerberosContext kerberosContext;
    private final MockFlowFileQueue flowFileQueue;
    private final SharedSessionState sharedState;
    private final AtomicLong idGenerator;
    private final boolean triggerSerially;
    private final MockStateManager processorStateManager;
    private final Map<String, MockStateManager> controllerServiceStateManagers = new HashMap<String, MockStateManager>();
    private int numThreads = 1;
    private MockSessionFactory sessionFactory;
    private boolean allowSynchronousSessionCommits = false;
    private boolean allowRecursiveReads = false;
    private long runSchedule = 0L;
    private final AtomicInteger invocations = new AtomicInteger(0);
    private final Map<String, MockComponentLog> controllerServiceLoggers = new HashMap<String, MockComponentLog>();
    private final MockComponentLog logger;
    private boolean enforceReadStreamsClosed = true;
    private boolean validateExpressionUsage = true;
    private final Map<String, String> environmentVariables = new HashMap<String, String>();

    StandardProcessorTestRunner(Processor processor) {
        this(processor, null);
    }

    StandardProcessorTestRunner(Processor processor, String processorName) {
        this(processor, processorName, null, null);
    }

    StandardProcessorTestRunner(Processor processor, String processorName, KerberosContext kerberosContext) {
        this(processor, processorName, null, kerberosContext);
    }

    StandardProcessorTestRunner(Processor processor, String processorName, MockComponentLog logger) {
        this(processor, processorName, logger, null);
    }

    StandardProcessorTestRunner(Processor processor, String processorName, MockComponentLog logger, KerberosContext kerberosContext) {
        this.processor = processor;
        this.idGenerator = new AtomicLong(0L);
        this.sharedState = new SharedSessionState(processor, this.idGenerator);
        this.flowFileQueue = this.sharedState.getFlowFileQueue();
        this.processorStateManager = new MockStateManager(processor);
        this.sessionFactory = new MockSessionFactory(this.sharedState, processor, this.enforceReadStreamsClosed, this.processorStateManager, this.allowSynchronousSessionCommits, this.allowRecursiveReads);
        this.context = new MockProcessContext((ConfigurableComponent)processor, processorName, (StateManager)this.processorStateManager, this.environmentVariables);
        this.kerberosContext = kerberosContext;
        MockProcessorInitializationContext mockInitContext = new MockProcessorInitializationContext(processor, this.context, logger, kerberosContext);
        processor.initialize((ProcessorInitializationContext)mockInitContext);
        this.logger = mockInitContext.getLogger();
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, processor, new Object[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)("Could not invoke methods annotated with @OnAdded annotation due to: " + String.valueOf(e)));
        }
        this.triggerSerially = null != processor.getClass().getAnnotation(TriggerSerially.class);
    }

    @Override
    public void enforceReadStreamsClosed(boolean enforce) {
        this.enforceReadStreamsClosed = enforce;
        this.sessionFactory = new MockSessionFactory(this.sharedState, this.processor, this.enforceReadStreamsClosed, this.processorStateManager, this.allowSynchronousSessionCommits, this.allowRecursiveReads);
    }

    @Override
    public void setValidateExpressionUsage(boolean validate) {
        this.validateExpressionUsage = validate;
        this.context.setValidateExpressionUsage(validate);
    }

    @Override
    public void setAllowSynchronousSessionCommits(boolean allowSynchronousSessionCommits) {
        this.allowSynchronousSessionCommits = allowSynchronousSessionCommits;
        this.sessionFactory = new MockSessionFactory(this.sharedState, this.processor, this.enforceReadStreamsClosed, this.processorStateManager, allowSynchronousSessionCommits, this.allowRecursiveReads);
    }

    @Override
    public void setAllowRecursiveReads(boolean allowRecursiveReads) {
        this.allowRecursiveReads = allowRecursiveReads;
        this.sessionFactory = new MockSessionFactory(this.sharedState, this.processor, this.enforceReadStreamsClosed, this.processorStateManager, this.allowSynchronousSessionCommits, allowRecursiveReads);
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public MockProcessContext getProcessContext() {
        return this.context;
    }

    @Override
    public boolean isYieldCalled() {
        return this.getProcessContext().isYieldCalled();
    }

    @Override
    public void run() {
        this.run(1);
    }

    @Override
    public void run(int iterations) {
        this.run(iterations, true);
    }

    @Override
    public void run(int iterations, boolean stopOnFinish) {
        this.run(iterations, stopOnFinish, true);
    }

    @Override
    public void run(int iterations, boolean stopOnFinish, boolean initialize) {
        this.run(iterations, stopOnFinish, initialize, 5000L + (long)iterations * this.runSchedule);
    }

    @Override
    public void run(int iterations, boolean stopOnFinish, boolean initialize, long runWait) {
        if (iterations < 0) {
            throw new IllegalArgumentException();
        }
        this.context.assertValid();
        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, this.processor, this.context);
        if (initialize) {
            try {
                ReflectionUtils.invokeMethodsWithAnnotation(OnScheduled.class, this.processor, this.context);
            }
            catch (Exception e) {
                Assertions.fail((String)("Could not invoke methods annotated with @OnScheduled annotation due to: " + String.valueOf(e)), (Throwable)e);
            }
        }
        Future[] futures = new Future[iterations];
        try (ScheduledExecutorService executorService = Executors.newScheduledThreadPool(this.numThreads);){
            for (int i = 0; i < iterations; ++i) {
                ScheduledFuture<Throwable> future;
                futures[i] = future = executorService.schedule(new RunProcessor(), (long)i * this.runSchedule, TimeUnit.MILLISECONDS);
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(runWait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
        }
        int finishedCount = 0;
        boolean unscheduledRun = false;
        for (Future future : futures) {
            try {
                Throwable thrown = (Throwable)future.get();
                if (thrown != null) {
                    throw new AssertionError((Object)thrown);
                }
                if (++finishedCount != 1 || !stopOnFinish) continue;
                unscheduledRun = true;
                this.unSchedule();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        if (!unscheduledRun && stopOnFinish) {
            this.unSchedule();
        }
        if (stopOnFinish) {
            this.stop();
        }
    }

    @Override
    public void unSchedule() {
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnUnscheduled.class, this.processor, this.context);
        }
        catch (Exception e) {
            Assertions.fail((String)("Could not invoke methods annotated with @OnUnscheduled annotation due to: " + String.valueOf(e)));
        }
    }

    @Override
    public void stop() {
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnStopped.class, this.processor, this.context);
        }
        catch (Exception e) {
            Assertions.fail((String)("Could not invoke methods annotated with @OnStopped annotation due to: " + String.valueOf(e)));
        }
    }

    @Override
    public void shutdown() {
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnShutdown.class, this.processor, new Object[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)("Could not invoke methods annotated with @OnShutdown annotation due to: " + String.valueOf(e)));
        }
    }

    @Override
    public ProcessSessionFactory getProcessSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void assertAllFlowFilesTransferred(String relationship) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFilesTransferred(relationship);
        }
    }

    @Override
    public void assertAllFlowFilesTransferred(Relationship relationship) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFilesTransferred(relationship);
        }
    }

    @Override
    public void assertAllFlowFilesTransferred(String relationship, int count) {
        this.assertAllFlowFilesTransferred(relationship);
        this.assertTransferCount(relationship, count);
    }

    @Override
    public void assertAllFlowFilesContainAttribute(String attributeName) {
        this.assertAllFlowFiles(f -> Assertions.assertNotNull((Object)f.getAttribute(attributeName)));
    }

    @Override
    public void assertAllFlowFilesContainAttribute(Relationship relationship, String attributeName) {
        this.assertAllFlowFiles(relationship, f -> Assertions.assertNotNull((Object)f.getAttribute(attributeName)));
    }

    @Override
    public void assertAllFlowFiles(FlowFileValidator validator) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFiles(validator);
        }
    }

    @Override
    public void assertAllFlowFiles(Relationship relationship, FlowFileValidator validator) {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.assertAllFlowFiles(relationship, validator);
        }
    }

    @Override
    public void assertAttributes(Relationship relationship, Set<String> checkedAttributeNames, Set<Map<String, String>> expectedAttributes) {
        this.assertTransferCount(relationship, expectedAttributes.size());
        List<MockFlowFile> flowFiles = this.getFlowFilesForRelationship(relationship);
        Set actualAttributes = flowFiles.stream().map(flowFile -> flowFile.getAttributes().entrySet().stream().filter(attributeNameAndValue -> checkedAttributeNames.contains(attributeNameAndValue.getKey())).filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).collect(Collectors.toSet());
        Assertions.assertEquals(expectedAttributes, actualAttributes);
    }

    @Override
    public void assertContents(Relationship relationship, List<String> expectedContent) {
        this.assertTransferCount(relationship, expectedContent.size());
        List<MockFlowFile> flowFiles = this.getFlowFilesForRelationship(relationship);
        List actualContent = flowFiles.stream().map(MockFlowFile::getContent).collect(Collectors.toList());
        Assertions.assertEquals(expectedContent, actualContent);
    }

    @Override
    public void assertAllFlowFilesTransferred(Relationship relationship, int count) {
        this.assertAllFlowFilesTransferred(relationship);
        this.assertTransferCount(relationship, count);
    }

    @Override
    public void assertTransferCount(Relationship relationship, int count) {
        Assertions.assertEquals((int)count, (int)this.getFlowFilesForRelationship(relationship).size());
    }

    @Override
    public void assertTransferCount(String relationship, int count) {
        Assertions.assertEquals((int)count, (int)this.getFlowFilesForRelationship(relationship).size());
    }

    @Override
    public void assertPenalizeCount(int count) {
        Assertions.assertEquals((int)count, (int)this.getPenalizedFlowFiles().size());
    }

    @Override
    public void assertValid() {
        this.context.assertValid();
    }

    @Override
    public Collection<ValidationResult> validate() {
        return this.context.validate();
    }

    @Override
    public List<ConfigVerificationResult> verify(Map<String, String> variables) {
        Processor processor = this.processor;
        if (processor instanceof VerifiableProcessor) {
            VerifiableProcessor vProcessor = (VerifiableProcessor)processor;
            return vProcessor.verify((ProcessContext)this.context, (ComponentLog)this.logger, variables);
        }
        throw new IllegalStateException("The Processor does not implement the VerifiableProcessor interface");
    }

    @Override
    public boolean isValid() {
        return this.context.isValid();
    }

    @Override
    public void assertNotValid() {
        Assertions.assertFalse((boolean)this.context.isValid(), (String)"Processor appears to be valid but expected it to be invalid");
    }

    @Override
    public boolean isQueueEmpty() {
        return this.flowFileQueue.isEmpty();
    }

    @Override
    public void assertQueueEmpty() {
        Assertions.assertTrue((boolean)this.flowFileQueue.isEmpty());
    }

    @Override
    public void assertQueueNotEmpty() {
        Assertions.assertFalse((boolean)this.flowFileQueue.isEmpty());
    }

    @Override
    public void clearTransferState() {
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            session.clearTransferState();
        }
    }

    @Override
    public void enqueue(FlowFile ... flowFiles) {
        for (FlowFile flowFile : flowFiles) {
            this.flowFileQueue.offer((MockFlowFile)flowFile);
        }
    }

    @Override
    public MockFlowFile enqueue(Path path) throws IOException {
        return this.enqueue(path, new HashMap<String, String>());
    }

    @Override
    public MockFlowFile enqueue(Path path, Map<String, String> attributes) throws IOException {
        HashMap<String, String> modifiedAttributes = new HashMap<String, String>(attributes);
        if (!modifiedAttributes.containsKey(CoreAttributes.FILENAME.key())) {
            modifiedAttributes.put(CoreAttributes.FILENAME.key(), path.toFile().getName());
        }
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            MockFlowFile mockFlowFile = this.enqueue(in, modifiedAttributes);
            return mockFlowFile;
        }
    }

    @Override
    public MockFlowFile enqueue(byte[] data) {
        return this.enqueue(data, new HashMap<String, String>());
    }

    @Override
    public MockFlowFile enqueue(String data) {
        return this.enqueue(data.getBytes(StandardCharsets.UTF_8), Collections.emptyMap());
    }

    @Override
    public MockFlowFile enqueue(byte[] data, Map<String, String> attributes) {
        return this.enqueue(new ByteArrayInputStream(data), attributes);
    }

    @Override
    public MockFlowFile enqueue(String data, Map<String, String> attributes) {
        return this.enqueue(data.getBytes(StandardCharsets.UTF_8), attributes);
    }

    @Override
    public MockFlowFile enqueue(InputStream data) {
        return this.enqueue(data, new HashMap<String, String>());
    }

    @Override
    public MockFlowFile enqueue(InputStream data, Map<String, String> attributes) {
        MockProcessSession session = new MockProcessSession(new SharedSessionState(this.processor, this.idGenerator), this.processor, this.enforceReadStreamsClosed, this.processorStateManager);
        MockFlowFile flowFile = session.create();
        flowFile = session.importFrom(data, flowFile);
        flowFile = session.putAllAttributes((FlowFile)flowFile, (Map)attributes);
        this.enqueue(flowFile);
        return flowFile;
    }

    @Override
    public byte[] getContentAsByteArray(MockFlowFile flowFile) {
        return flowFile.getData();
    }

    @Override
    public List<MockFlowFile> getFlowFilesForRelationship(String relationship) {
        Relationship rel = new Relationship.Builder().name(relationship).build();
        return this.getFlowFilesForRelationship(rel);
    }

    @Override
    public List<MockFlowFile> getFlowFilesForRelationship(Relationship relationship) {
        ArrayList<MockFlowFile> flowFiles = new ArrayList<MockFlowFile>();
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            flowFiles.addAll(session.getFlowFilesForRelationship(relationship));
        }
        return flowFiles;
    }

    @Override
    public List<MockFlowFile> getPenalizedFlowFiles() {
        ArrayList<MockFlowFile> flowFiles = new ArrayList<MockFlowFile>();
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            flowFiles.addAll(session.getPenalizedFlowFiles());
        }
        return flowFiles;
    }

    @Override
    public QueueSize getQueueSize() {
        return this.flowFileQueue.size();
    }

    @Override
    public void clearQueue() {
        while (!this.flowFileQueue.isEmpty()) {
            this.flowFileQueue.poll();
        }
    }

    @Override
    public Long getCounterValue(String name) {
        return this.sharedState.getCounterValue(name);
    }

    @Override
    public int getRemovedCount() {
        int count = 0;
        for (MockProcessSession session : this.sessionFactory.getCreatedSessions()) {
            count += session.getRemovedCount();
        }
        return count;
    }

    @Override
    public void setAnnotationData(String annotationData) {
        this.context.setAnnotationData(annotationData);
    }

    @Override
    public ValidationResult setProperty(String propertyName, String propertyValue) {
        return this.context.setProperty(propertyName, propertyValue);
    }

    @Override
    public ValidationResult setProperty(PropertyDescriptor descriptor, String value) {
        return this.context.setProperty(descriptor, value);
    }

    @Override
    public ValidationResult setProperty(PropertyDescriptor descriptor, DescribedValue value) {
        return this.context.setProperty(descriptor, value.getValue());
    }

    @Override
    public void setThreadCount(int threadCount) {
        if (threadCount > 1 && this.triggerSerially) {
            Assertions.fail((String)"Cannot set thread-count higher than 1 because the processor is triggered serially");
        }
        this.numThreads = threadCount;
        this.context.setMaxConcurrentTasks(threadCount);
    }

    @Override
    public int getThreadCount() {
        return this.numThreads;
    }

    @Override
    public void setRelationshipAvailable(Relationship relationship) {
        HashSet<Relationship> unavailable = new HashSet<Relationship>(this.context.getUnavailableRelationships());
        unavailable.remove(relationship);
        this.context.setUnavailableRelationships(unavailable);
    }

    @Override
    public void setRelationshipAvailable(String relationshipName) {
        this.setRelationshipAvailable(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void setRelationshipUnavailable(Relationship relationship) {
        HashSet<Relationship> unavailable = new HashSet<Relationship>(this.context.getUnavailableRelationships());
        unavailable.add(relationship);
        this.context.setUnavailableRelationships(unavailable);
    }

    @Override
    public void setRelationshipUnavailable(String relationshipName) {
        this.setRelationshipUnavailable(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void setIncomingConnection(boolean hasIncomingConnection) {
        this.context.setIncomingConnection(hasIncomingConnection);
    }

    @Override
    public void setNonLoopConnection(boolean hasNonLoopConnection) {
        this.context.setNonLoopConnection(hasNonLoopConnection);
    }

    @Override
    public void addConnection(Relationship relationship) {
        this.context.addConnection(relationship);
    }

    @Override
    public void addConnection(String relationshipName) {
        this.addConnection(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void removeConnection(Relationship relationship) {
        this.context.removeConnection(relationship);
    }

    @Override
    public void removeConnection(String relationshipName) {
        this.removeConnection(new Relationship.Builder().name(relationshipName).build());
    }

    @Override
    public void addControllerService(String identifier, ControllerService service) throws InitializationException {
        this.addControllerService(identifier, service, new HashMap<String, String>());
    }

    @Override
    public void addControllerService(String identifier, ControllerService service, Map<String, String> properties) throws InitializationException {
        MockComponentLog mockComponentLog = new MockComponentLog(identifier, service);
        this.controllerServiceLoggers.put(identifier, mockComponentLog);
        MockStateManager serviceStateManager = new MockStateManager(service);
        MockControllerServiceInitializationContext initContext = new MockControllerServiceInitializationContext(Objects.requireNonNull(service), Objects.requireNonNull(identifier), mockComponentLog, serviceStateManager, this.kerberosContext);
        this.controllerServiceStateManagers.put(identifier, serviceStateManager);
        initContext.addControllerServices(this.context);
        service.initialize((ControllerServiceInitializationContext)initContext);
        HashMap<PropertyDescriptor, String> resolvedProps = new HashMap<PropertyDescriptor, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            resolvedProps.put(service.getPropertyDescriptor(entry.getKey()), entry.getValue());
        }
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, service, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InitializationException((Throwable)e);
        }
        this.context.addControllerService(service, resolvedProps, null);
    }

    @Override
    public void assertNotValid(ControllerService service) {
        StateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller Service has not been added to this TestRunner via the #addControllerService method");
        }
        ValidationContext validationContext = new MockValidationContext(this.context, serviceStateManager).getControllerServiceValidationContext(service);
        ControllerService canonicalService = this.context.getControllerService(service.getIdentifier());
        Collection results = canonicalService.validate(validationContext);
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            return;
        }
        Assertions.fail((String)("Expected Controller Service " + String.valueOf(service) + " to be invalid but it is valid"));
    }

    @Override
    public void assertValid(ControllerService service) {
        Collection<ValidationResult> results = this.validate(service);
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            Assertions.fail((String)("Expected Controller Service to be valid but it is invalid due to: " + String.valueOf(result)));
        }
    }

    @Override
    public Collection<ValidationResult> validate(ControllerService service) {
        StateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller Service has not been added to this TestRunner via the #addControllerService method");
        }
        ValidationContext validationContext = new MockValidationContext(this.context, serviceStateManager).getControllerServiceValidationContext(service);
        return this.context.getControllerService(service.getIdentifier()).validate(validationContext);
    }

    @Override
    public List<ConfigVerificationResult> verify(ControllerService service, Map<String, String> variables) {
        if (service instanceof VerifiableControllerService) {
            VerifiableControllerService vService = (VerifiableControllerService)service;
            StateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
            if (serviceStateManager == null) {
                throw new IllegalStateException("Controller Service has not been added to this TestRunner via the #addControllerService method");
            }
            ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
            MockConfigurationContext configContext = new MockConfigurationContext(service, configuration.getProperties(), this.context, this.environmentVariables);
            configContext.setValidateExpressions(this.validateExpressionUsage);
            return vService.verify((ConfigurationContext)configContext, (ComponentLog)this.getControllerServiceLogger(service.getIdentifier()), variables);
        }
        throw new IllegalStateException("The Controller Service does not implement the VerifiableControllerService interface");
    }

    @Override
    public void disableControllerService(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + String.valueOf(service) + " is not known");
        }
        if (!configuration.isEnabled()) {
            throw new IllegalStateException("Controller service " + String.valueOf(service) + " cannot be disabled because it is not enabled");
        }
        try {
            MockConfigurationContext configContext = new MockConfigurationContext(service, configuration.getProperties(), this.context, this.environmentVariables);
            configContext.setValidateExpressions(this.validateExpressionUsage);
            ReflectionUtils.invokeMethodsWithAnnotation(OnDisabled.class, service, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Failed to disable Controller Service " + String.valueOf(service) + " due to " + String.valueOf(e)));
        }
        configuration.setEnabled(false);
    }

    @Override
    public void enableControllerService(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + String.valueOf(service) + " is not known");
        }
        if (configuration.isEnabled()) {
            throw new IllegalStateException("Cannot enable Controller Service " + String.valueOf(service) + " because it is not disabled");
        }
        MockValidationContext mockValidationContext = new MockValidationContext(this.context, null);
        mockValidationContext.setValidateExpressions(this.validateExpressionUsage);
        ValidationContext serviceValidationContext = mockValidationContext.getControllerServiceValidationContext(service);
        Collection results = this.context.getControllerService(service.getIdentifier()).validate(serviceValidationContext);
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            throw new IllegalStateException("Cannot enable Controller Service " + String.valueOf(service) + " because it is in an invalid state: " + String.valueOf(result));
        }
        try {
            MockConfigurationContext configContext = new MockConfigurationContext(service, configuration.getProperties(), this.context, this.environmentVariables);
            configContext.setValidateExpressions(this.validateExpressionUsage);
            ReflectionUtils.invokeMethodsWithAnnotation(OnEnabled.class, service, configContext);
        }
        catch (InvocationTargetException ite) {
            ite.getCause().printStackTrace();
            Assertions.fail((String)("Failed to enable Controller Service " + String.valueOf(service) + " due to " + String.valueOf(ite.getCause())));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Failed to enable Controller Service " + String.valueOf(service) + " due to " + String.valueOf(e)));
        }
        configuration.setEnabled(true);
    }

    @Override
    public boolean isControllerServiceEnabled(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + String.valueOf(service) + " is not known");
        }
        return configuration.isEnabled();
    }

    @Override
    public void removeControllerService(ControllerService service) {
        if (this.context.getControllerServiceLookup().isControllerServiceEnabled(service)) {
            this.disableControllerService(service);
        }
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnRemoved.class, service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Failed to remove Controller Service " + String.valueOf(service) + " due to " + String.valueOf(e)));
        }
        this.context.removeControllerService(service);
    }

    @Override
    public void setAnnotationData(ControllerService service, String annotationData) {
        ControllerServiceConfiguration configuration = this.getConfigToUpdate(service);
        configuration.setAnnotationData(annotationData);
    }

    private ControllerServiceConfiguration getConfigToUpdate(ControllerService service) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + String.valueOf(service) + " is not known");
        }
        if (configuration.isEnabled()) {
            throw new IllegalStateException("Controller service " + String.valueOf(service) + " cannot be modified because it is not disabled");
        }
        return configuration;
    }

    @Override
    public ValidationResult setProperty(ControllerService service, PropertyDescriptor property, DescribedValue value) {
        return this.setProperty(service, property, value.getValue());
    }

    @Override
    public ValidationResult setProperty(ControllerService service, PropertyDescriptor property, String value) {
        MockStateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller service " + String.valueOf(service) + " has not been added to this TestRunner via the #addControllerService method");
        }
        ControllerServiceConfiguration configuration = this.getConfigToUpdate(service);
        Map<PropertyDescriptor, String> curProps = configuration.getProperties();
        HashMap<PropertyDescriptor, String> updatedProps = new HashMap<PropertyDescriptor, String>(curProps);
        ValidationContext validationContext = new MockValidationContext(this.context, serviceStateManager).getControllerServiceValidationContext(service);
        boolean dependencySatisfied = validationContext.isDependencySatisfied(property, arg_0 -> ((Processor)this.processor).getPropertyDescriptor(arg_0));
        ValidationResult validationResult = dependencySatisfied ? property.validate(value, validationContext) : new ValidationResult.Builder().valid(true).input(value).subject(property.getDisplayName()).explanation("Property is dependent upon another property, and this dependency is not satisfied, so value is considered valid").build();
        String oldValue = (String)updatedProps.get(property);
        updatedProps.put(property, value);
        configuration.setProperties(updatedProps);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            service.onPropertyModified(property, oldValue, value);
        }
        return validationResult;
    }

    @Override
    public ValidationResult setProperty(ControllerService service, String propertyName, String value) {
        PropertyDescriptor descriptor = service.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return new ValidationResult.Builder().input(propertyName).explanation(propertyName + " is not a known Property for Controller Service " + String.valueOf(service)).subject("Invalid property").valid(false).build();
        }
        return this.setProperty(service, descriptor, value);
    }

    @Override
    public ControllerService getControllerService(String identifier) {
        return this.context.getControllerService(identifier);
    }

    @Override
    public <T extends ControllerService> T getControllerService(String identifier, Class<T> serviceType) {
        ControllerService service = this.context.getControllerService(identifier);
        return (T)((ControllerService)serviceType.cast(service));
    }

    @Override
    public boolean removeProperty(PropertyDescriptor descriptor) {
        return this.context.removeProperty(descriptor);
    }

    @Override
    public boolean removeProperty(String property) {
        return this.context.removeProperty(property);
    }

    @Override
    public boolean removeProperty(ControllerService service, PropertyDescriptor property) {
        MockStateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller service " + String.valueOf(service) + " has not been added to this TestRunner via the #addControllerService method");
        }
        ControllerServiceConfiguration configuration = this.getConfigToUpdate(service);
        Map<PropertyDescriptor, String> curProps = configuration.getProperties();
        HashMap<PropertyDescriptor, String> updatedProps = new HashMap<PropertyDescriptor, String>(curProps);
        String oldValue = (String)updatedProps.remove(property);
        if (oldValue == null) {
            return false;
        }
        configuration.setProperties(updatedProps);
        service.onPropertyModified(property, oldValue, null);
        return true;
    }

    @Override
    public boolean removeProperty(ControllerService service, String propertyName) {
        PropertyDescriptor descriptor = service.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return false;
        }
        return this.removeProperty(service, descriptor);
    }

    @Override
    public void clearProperties() {
        this.context.clearProperties();
    }

    @Override
    public List<ProvenanceEventRecord> getProvenanceEvents() {
        return this.sharedState.getProvenanceEvents();
    }

    @Override
    public void clearProvenanceEvents() {
        this.sharedState.clearProvenanceEvents();
    }

    @Override
    public MockStateManager getStateManager() {
        return this.processorStateManager;
    }

    @Override
    public MockStateManager getStateManager(ControllerService controllerService) {
        return this.controllerServiceStateManagers.get(controllerService.getIdentifier());
    }

    @Override
    public MockComponentLog getLogger() {
        return this.logger;
    }

    @Override
    public MockComponentLog getControllerServiceLogger(String identifier) {
        return this.controllerServiceLoggers.get(identifier);
    }

    @Override
    public void setClustered(boolean clustered) {
        this.context.setClustered(clustered);
    }

    @Override
    public void setIsConfiguredForClustering(boolean isConfiguredForClustering) {
        this.context.setIsConfiguredForClustering(isConfiguredForClustering);
    }

    @Override
    public void setPrimaryNode(boolean primaryNode) {
        if (this.context.isPrimary() != primaryNode) {
            try {
                ReflectionUtils.invokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, this.processor, primaryNode ? PrimaryNodeState.ELECTED_PRIMARY_NODE : PrimaryNodeState.PRIMARY_NODE_REVOKED);
            }
            catch (Exception e) {
                Assertions.fail((String)("Could not invoke methods annotated with @OnPrimaryNodeStateChange annotation due to: " + String.valueOf(e)));
            }
        }
        this.context.setPrimaryNode(primaryNode);
    }

    @Override
    public void setConnected(boolean isConnected) {
        this.context.setConnected(isConnected);
    }

    @Override
    public String getEnvironmentVariableValue(String name) {
        Objects.requireNonNull(name);
        if (this.environmentVariables.containsKey(name)) {
            return this.environmentVariables.get(name);
        }
        return EnvironmentVariables.ENVIRONMENT_VARIABLES.getEnvironmentVariableValue(name);
    }

    @Override
    public void setEnvironmentVariableValue(String name, String value) {
        this.environmentVariables.put(name, value);
    }

    @Override
    public void assertAllConditionsMet(String relationshipName, Predicate<MockFlowFile> predicate) {
        this.assertAllConditionsMet(new Relationship.Builder().name(relationshipName).build(), predicate);
    }

    @Override
    public void assertAllConditionsMet(Relationship relationship, Predicate<MockFlowFile> predicate) {
        List<MockFlowFile> flowFiles;
        if (predicate == null) {
            Assertions.fail((String)"predicate cannot be null");
        }
        if ((flowFiles = this.getFlowFilesForRelationship(relationship)).isEmpty()) {
            Assertions.fail((String)("Relationship " + relationship.getName() + " does not contain any FlowFile"));
        }
        for (MockFlowFile flowFile : flowFiles) {
            if (predicate.test(flowFile)) continue;
            Assertions.fail((String)("FlowFile " + String.valueOf(flowFile) + " does not meet all condition"));
        }
    }

    @Override
    public void setRunSchedule(long runSchedule) {
        this.runSchedule = runSchedule;
    }

    @Override
    public void assertProvenanceEvent(ProvenanceEventType eventType) {
        Set<ProvenanceEventType> expectedEventTypes = Collections.singleton(eventType);
        Set actualEventTypes = this.getProvenanceEvents().stream().map(ProvenanceEventRecord::getEventType).collect(Collectors.toSet());
        Assertions.assertEquals(expectedEventTypes, actualEventTypes);
    }

    @Override
    public PropertyMigrationResult migrateProperties() {
        MockPropertyConfiguration mockPropertyConfiguration = new MockPropertyConfiguration(this.context.getAllProperties());
        this.getProcessor().migrateProperties((PropertyConfiguration)mockPropertyConfiguration);
        PropertyMigrationResult migrationResult = mockPropertyConfiguration.toPropertyMigrationResult();
        Set<MockPropertyConfiguration.CreatedControllerService> services = migrationResult.getCreatedControllerServices();
        Throwable serviceCreationException = null;
        for (MockPropertyConfiguration.CreatedControllerService service : services) {
            try {
                Class<?> clazz = Class.forName(service.implementationClassName());
                Object newInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(newInstance instanceof ControllerService)) {
                    throw new RuntimeException(String.valueOf(clazz) + " is not a Controller Service");
                }
                ControllerService serviceImpl = (ControllerService)newInstance;
                this.addControllerService(service.id(), serviceImpl, service.serviceProperties());
                this.enableControllerService(serviceImpl);
            }
            catch (Exception e) {
                if (serviceCreationException == null) {
                    if (e instanceof RuntimeException) {
                        serviceCreationException = (RuntimeException)e;
                        continue;
                    }
                    serviceCreationException = new RuntimeException(e);
                    continue;
                }
                serviceCreationException.addSuppressed(e);
            }
        }
        if (serviceCreationException != null) {
            throw serviceCreationException;
        }
        Map<String, String> updatedProperties = mockPropertyConfiguration.getRawProperties();
        this.clearProperties();
        updatedProperties.forEach((propertyName, propertyValue) -> {
            if (propertyValue == null) {
                this.removeProperty((String)propertyName);
            } else {
                this.setProperty((String)propertyName, (String)propertyValue);
            }
        });
        return migrationResult;
    }

    @Override
    public RelationshipMigrationResult migrateRelationships() {
        MockRelationshipConfiguration mockRelationshipConfiguration = new MockRelationshipConfiguration(this.context.getAllRelationships());
        this.getProcessor().migrateRelationships((RelationshipConfiguration)mockRelationshipConfiguration);
        Set<Relationship> updatedRelationships = mockRelationshipConfiguration.getRawRelationships();
        this.context.clearConnections();
        updatedRelationships.forEach(this.context::addConnection);
        return mockRelationshipConfiguration.toRelationshipMigrationResult();
    }

    private class RunProcessor
    implements Callable<Throwable> {
        private RunProcessor() {
        }

        @Override
        public Throwable call() throws Exception {
            StandardProcessorTestRunner.this.invocations.incrementAndGet();
            try {
                StandardProcessorTestRunner.this.processor.onTrigger((ProcessContext)StandardProcessorTestRunner.this.context, (ProcessSessionFactory)StandardProcessorTestRunner.this.sessionFactory);
            }
            catch (Throwable t) {
                return t;
            }
            return null;
        }
    }
}

