/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinFactory;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.MockBulletinRepository;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockEventAccess;
import org.apache.nifi.util.MockPropertyValue;

public class MockReportingContext
extends MockControllerServiceLookup
implements ReportingContext,
ControllerServiceLookup {
    private final Map<String, ControllerServiceConfiguration> controllerServices;
    private final MockEventAccess eventAccess = new MockEventAccess();
    private final Map<PropertyDescriptor, String> properties = new HashMap<PropertyDescriptor, String>();
    private final StateManager stateManager;
    private final Map<String, List<Bulletin>> componentBulletinsCreated = new HashMap<String, List<Bulletin>>();

    public MockReportingContext(Map<String, ControllerService> controllerServices, StateManager stateManager) {
        this.controllerServices = new HashMap<String, ControllerServiceConfiguration>();
        this.stateManager = stateManager;
        for (Map.Entry<String, ControllerService> entry : controllerServices.entrySet()) {
            this.controllerServices.put(entry.getKey(), new ControllerServiceConfiguration(entry.getValue()));
        }
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.properties.get(property);
        return new MockPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, this, null);
    }

    public void setProperty(String propertyName, String value) {
        this.properties.put(new PropertyDescriptor.Builder().name(propertyName).build(), value);
    }

    public void setProperties(Map<PropertyDescriptor, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public MockEventAccess getEventAccess() {
        return this.eventAccess;
    }

    public BulletinRepository getBulletinRepository() {
        return new MockBulletinRepository();
    }

    public Bulletin createBulletin(String category, Severity severity, String message) {
        return BulletinFactory.createBulletin(category, severity.name(), message);
    }

    public Bulletin createBulletin(String componentId, String category, Severity severity, String message) {
        Bulletin bulletin = BulletinFactory.createBulletin(null, null, componentId, "test processor", category, severity.name(), message);
        List bulletins = this.componentBulletinsCreated.computeIfAbsent(componentId, k -> new ArrayList());
        bulletins.add(bulletin);
        return bulletin;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public List<Bulletin> getComponentBulletins(String componentId) {
        List<Bulletin> created = this.componentBulletinsCreated.get(componentId);
        if (created == null) {
            return new ArrayList<Bulletin>();
        }
        return new ArrayList<Bulletin>(created);
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public boolean isClustered() {
        return false;
    }

    public String getClusterNodeIdentifier() {
        return null;
    }
}

