/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.util.MockPropertyValue;

public class MockPropertyContext
implements PropertyContext {
    private final Map<PropertyDescriptor, String> properties;

    public MockPropertyContext(Map<PropertyDescriptor, String> properties) {
        this.properties = properties;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String value = this.properties.get(property);
        if (value == null) {
            value = property.getDefaultValue();
        }
        return new MockPropertyValue(value, null);
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.properties.entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }
}

