/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.metrics.jvm;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.processor.DataUnit;

public interface JvmMetrics {
    public double totalInit(DataUnit var1);

    public double totalUsed(DataUnit var1);

    public double totalMax(DataUnit var1);

    public double totalCommitted(DataUnit var1);

    public double heapInit(DataUnit var1);

    public double heapUsed(DataUnit var1);

    public double heapMax(DataUnit var1);

    public double heapCommitted(DataUnit var1);

    public double heapUsage();

    public double nonHeapUsage();

    public Map<String, Double> memoryPoolUsage();

    public double fileDescriptorUsage();

    public String version();

    public String name();

    public long uptime();

    public int threadCount();

    public int daemonThreadCount();

    public Map<String, GarbageCollectorStats> garbageCollectors();

    public Set<String> deadlockedThreads();

    public Map<Thread.State, Double> threadStatePercentages();

    public void threadDump(OutputStream var1);

    public Map<String, BufferPoolStats> getBufferPoolStats();

    public static class BufferPoolStats {
        private final long count;
        private final long memoryUsed;
        private final long totalCapacity;

        BufferPoolStats(long count, long memoryUsed, long totalCapacity) {
            this.count = count;
            this.memoryUsed = memoryUsed;
            this.totalCapacity = totalCapacity;
        }

        public long getCount() {
            return this.count;
        }

        public long getMemoryUsed(DataUnit dataUnit) {
            return (long)dataUnit.convert((double)this.memoryUsed, DataUnit.B);
        }

        public long getTotalCapacity(DataUnit dataUnit) {
            return this.totalCapacity;
        }
    }

    public static class GarbageCollectorStats {
        private final long runs;
        private final long timeMS;

        GarbageCollectorStats(long runs, long timeMS) {
            this.runs = runs;
            this.timeMS = timeMS;
        }

        public long getRuns() {
            return this.runs;
        }

        public long getTime(TimeUnit unit) {
            return unit.convert(this.timeMS, TimeUnit.MILLISECONDS);
        }
    }
}

