/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.key.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.key.service.api.PrivateKeyService;
import org.apache.nifi.key.service.reader.BouncyCastlePrivateKeyReader;
import org.apache.nifi.key.service.reader.PrivateKeyReader;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

@Tags(value={"PEM", "PKCS8"})
@CapabilityDescription(value="Private Key Service provides access to a Private Key loaded from configured sources")
public class StandardPrivateKeyService
extends AbstractControllerService
implements PrivateKeyService {
    public static final PropertyDescriptor KEY_FILE = new PropertyDescriptor.Builder().name("key-file").displayName("Key File").description("File path to Private Key structured using PKCS8 and encoded as PEM").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("key").displayName("Key").description("Private Key structured using PKCS8 and encoded as PEM").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY_PASSWORD = new PropertyDescriptor.Builder().name("key-password").displayName("Key Password").description("Password used for decrypting Private Keys").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(KEY_FILE, KEY, KEY_PASSWORD);
    private static final Charset KEY_CHARACTER_SET = StandardCharsets.US_ASCII;
    private static final PrivateKeyReader PRIVATE_KEY_READER = new BouncyCastlePrivateKeyReader();
    private final AtomicReference<PrivateKey> keyReference = new AtomicReference();

    public PrivateKey getPrivateKey() {
        return this.keyReference.get();
    }

    public void onPropertyModified(PropertyDescriptor propertyDescriptor, String oldValue, String newValue) {
        this.keyReference.set(null);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        try {
            PrivateKey readKey = this.readKey((PropertyContext)context);
            this.keyReference.set(readKey);
        }
        catch (RuntimeException e) {
            throw new InitializationException("Reading Private Key Failed", (Throwable)e);
        }
    }

    @OnDisabled
    public void onDisabled() {
        this.keyReference.set(null);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        PropertyValue keyFileProperty = context.getProperty(KEY_FILE);
        PropertyValue keyProperty = context.getProperty(KEY);
        if (keyFileProperty.isSet() && keyProperty.isSet()) {
            String explanation = String.format("Both [%s] and [%s] properties configured", KEY_FILE.getDisplayName(), KEY.getDisplayName());
            ValidationResult result = new ValidationResult.Builder().valid(false).subject(KEY.getDisplayName()).explanation(explanation).build();
            results.add(result);
        } else if (this.keyReference.get() == null) {
            try {
                PrivateKey readKey = this.readKey((PropertyContext)context);
                this.keyReference.set(readKey);
            }
            catch (RuntimeException e) {
                ValidationResult result = new ValidationResult.Builder().valid(false).subject(KEY.getDisplayName()).explanation(e.getMessage()).build();
                results.add(result);
            }
        }
        return results;
    }

    private PrivateKey readKey(PropertyContext context) {
        PrivateKey readKey;
        block17: {
            char[] keyPassword = this.getKeyPassword(context);
            PropertyValue keyFileProperty = context.getProperty(KEY_FILE);
            PropertyValue keyProperty = context.getProperty(KEY);
            if (keyFileProperty.isSet()) {
                try (InputStream inputStream = keyFileProperty.asResource().read();){
                    readKey = PRIVATE_KEY_READER.readPrivateKey(inputStream, keyPassword);
                    break block17;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Read Private Key File failed", e);
                }
            }
            if (keyProperty.isSet()) {
                byte[] key = keyProperty.getValue().getBytes(KEY_CHARACTER_SET);
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(key);){
                    readKey = PRIVATE_KEY_READER.readPrivateKey(inputStream, keyPassword);
                    break block17;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Read Private Key failed", e);
                }
            }
            throw new IllegalStateException("Private Key not configured");
        }
        return readKey;
    }

    private char[] getKeyPassword(PropertyContext context) {
        PropertyValue keyPasswordProperty = context.getProperty(KEY_PASSWORD);
        return keyPasswordProperty.isSet() ? keyPasswordProperty.getValue().toCharArray() : new char[]{};
    }
}

