/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.property;

import org.apache.nifi.components.DescribedValue;

public enum OutputStrategy implements DescribedValue
{
    USE_VALUE("USE_VALUE", "Use Content as Value", "Write only the Kafka Record value to the FlowFile record."),
    USE_WRAPPER("USE_WRAPPER", "Use Wrapper", "Write the Kafka Record key, value, headers, and metadata into the FlowFile record. (See processor's additional details for more information.)"),
    INJECT_METADATA("INJECT_METADATA", "Inject Metadata", "Write the Kafka Record value to the FlowFile record and add a sub-record to it with key, headers, and metadata. (See processor's additional details for more information.)"),
    INJECT_OFFSET("INJECT_OFFSET", "Inject Offset", "Write the Kafka Record value to the FlowFile record and write the Kafka Record offset to a field named kafkaOffset");

    private final String value;
    private final String displayName;
    private final String description;

    private OutputStrategy(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

