/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.LoginConfigBuilder;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.kerberos.SelfContainedKerberosUserService;
import org.apache.nifi.security.krb.KerberosUser;

public class KerberosLoginConfigProvider
implements LoginConfigProvider {
    @Override
    public String getConfiguration(PropertyContext context) {
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE).asControllerService(SelfContainedKerberosUserService.class);
        KerberosUser kerberosUser = kerberosUserService.createKerberosUser();
        AppConfigurationEntry configurationEntry = kerberosUser.getConfigurationEntry();
        LoginConfigBuilder builder = new LoginConfigBuilder(configurationEntry.getLoginModuleName(), configurationEntry.getControlFlag());
        Map<String, ?> options = configurationEntry.getOptions();
        options.forEach(builder::append);
        return builder.build();
    }
}

