/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.property.provider;

import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.DelegatingLoginConfigProvider;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;
import org.apache.nifi.kafka.shared.property.KafkaClientProperty;
import org.apache.nifi.kafka.shared.property.SaslMechanism;
import org.apache.nifi.kafka.shared.property.SecurityProtocol;
import org.apache.nifi.kafka.shared.property.provider.KafkaPropertyProvider;
import org.apache.nifi.kafka.shared.property.provider.StandardKafkaPropertyNameProvider;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.FormatUtils;

public class StandardKafkaPropertyProvider
implements KafkaPropertyProvider {
    private static final String MILLISECOND_PROPERTY_SUFFIX = ".ms";
    private static final String SASL_GSSAPI_CUSTOM_LOGIN_CLASS = "org.apache.nifi.processors.kafka.pubsub.CustomKerberosLogin";
    public static final String SASL_AWS_MSK_IAM_CLIENT_CALLBACK_HANDLER_CLASS = "software.amazon.msk.auth.iam.IAMClientCallbackHandler";
    private static final LoginConfigProvider LOGIN_CONFIG_PROVIDER = new DelegatingLoginConfigProvider();
    private final Set<String> clientPropertyNames;

    public StandardKafkaPropertyProvider(Class<?> kafkaClientClass) {
        StandardKafkaPropertyNameProvider provider = new StandardKafkaPropertyNameProvider(kafkaClientClass);
        this.clientPropertyNames = provider.getPropertyNames();
    }

    @Override
    public Map<String, Object> getProperties(PropertyContext context) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.setClientProperties(properties, context);
        this.setSecurityProperties(properties, context);
        this.setSslProperties(properties, context);
        return properties;
    }

    private void setSecurityProperties(Map<String, Object> properties, PropertyContext context) {
        String protocol = context.getProperty(KafkaClientComponent.SECURITY_PROTOCOL).getValue();
        properties.put(KafkaClientComponent.SECURITY_PROTOCOL.getName(), protocol);
        SecurityProtocol securityProtocol = SecurityProtocol.valueOf(protocol);
        if (SecurityProtocol.SASL_PLAINTEXT == securityProtocol || SecurityProtocol.SASL_SSL == securityProtocol) {
            String loginConfig = LOGIN_CONFIG_PROVIDER.getConfiguration(context);
            properties.put(KafkaClientProperty.SASL_JAAS_CONFIG.getProperty(), loginConfig);
            SaslMechanism saslMechanism = (SaslMechanism)context.getProperty(KafkaClientComponent.SASL_MECHANISM).asAllowableValue(SaslMechanism.class);
            if (saslMechanism == SaslMechanism.GSSAPI && StandardKafkaPropertyProvider.isCustomKerberosLoginFound()) {
                properties.put(KafkaClientProperty.SASL_LOGIN_CLASS.getProperty(), SASL_GSSAPI_CUSTOM_LOGIN_CLASS);
            } else if (saslMechanism == SaslMechanism.AWS_MSK_IAM && StandardKafkaPropertyProvider.isAwsMskIamCallbackHandlerFound()) {
                properties.put(KafkaClientProperty.SASL_CLIENT_CALLBACK_HANDLER_CLASS.getProperty(), SASL_AWS_MSK_IAM_CLIENT_CALLBACK_HANDLER_CLASS);
            }
        }
    }

    private void setSslProperties(Map<String, Object> properties, PropertyContext context) {
        PropertyValue sslContextServiceProperty = context.getProperty(KafkaClientComponent.SSL_CONTEXT_SERVICE);
        if (sslContextServiceProperty.isSet()) {
            SSLContextService sslContextService = (SSLContextService)sslContextServiceProperty.asControllerService(SSLContextService.class);
            if (sslContextService.isKeyStoreConfigured()) {
                properties.put(KafkaClientProperty.SSL_KEYSTORE_LOCATION.getProperty(), sslContextService.getKeyStoreFile());
                properties.put(KafkaClientProperty.SSL_KEYSTORE_TYPE.getProperty(), sslContextService.getKeyStoreType());
                String keyStorePassword = sslContextService.getKeyStorePassword();
                properties.put(KafkaClientProperty.SSL_KEYSTORE_PASSWORD.getProperty(), keyStorePassword);
                String keyPassword = sslContextService.getKeyPassword();
                String configuredKeyPassword = keyPassword == null ? keyStorePassword : keyPassword;
                properties.put(KafkaClientProperty.SSL_KEY_PASSWORD.getProperty(), configuredKeyPassword);
            }
            if (sslContextService.isTrustStoreConfigured()) {
                properties.put(KafkaClientProperty.SSL_TRUSTSTORE_LOCATION.getProperty(), sslContextService.getTrustStoreFile());
                properties.put(KafkaClientProperty.SSL_TRUSTSTORE_TYPE.getProperty(), sslContextService.getTrustStoreType());
                properties.put(KafkaClientProperty.SSL_TRUSTSTORE_PASSWORD.getProperty(), sslContextService.getTrustStorePassword());
            }
        }
    }

    private void setClientProperties(Map<String, Object> properties, PropertyContext context) {
        Set propertyDescriptors = this.getPropertyDescriptors(context).stream().filter(propertyDescriptor -> this.clientPropertyNames.contains(propertyDescriptor.getName())).collect(Collectors.toSet());
        for (PropertyDescriptor propertyDescriptor2 : propertyDescriptors) {
            String propertyValue;
            PropertyValue property = context.getProperty(propertyDescriptor2);
            String string = propertyValue = propertyDescriptor2.isExpressionLanguageSupported() ? property.evaluateAttributeExpressions().getValue() : property.getValue();
            if (propertyValue == null) continue;
            String propertyName = propertyDescriptor2.getName();
            this.setProperty(properties, propertyName, propertyValue);
        }
    }

    private Set<PropertyDescriptor> getPropertyDescriptors(PropertyContext context) {
        PropertyContext propertyContext = context;
        Objects.requireNonNull(propertyContext);
        PropertyContext propertyContext2 = propertyContext;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfigurationContext.class, ProcessContext.class}, (Object)propertyContext2, n)) {
            case 0 -> {
                ConfigurationContext configurationContext = (ConfigurationContext)propertyContext2;
                yield configurationContext.getProperties().keySet();
            }
            case 1 -> {
                ProcessContext processContext = (ProcessContext)propertyContext2;
                yield processContext.getProperties().keySet();
            }
            default -> throw new IllegalArgumentException(String.format("Property Context [%s] not supported", context.getClass().getName()));
        };
    }

    private void setProperty(Map<String, Object> properties, String propertyName, String propertyValue) {
        if (propertyName.endsWith(MILLISECOND_PROPERTY_SUFFIX)) {
            Matcher durationMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(propertyValue);
            if (durationMatcher.matches()) {
                long milliseconds = Math.round(FormatUtils.getPreciseTimeDuration((String)propertyValue, (TimeUnit)TimeUnit.MILLISECONDS));
                properties.put(propertyName, Long.toString(milliseconds));
            } else {
                properties.put(propertyName, propertyValue);
            }
        } else {
            properties.put(propertyName, propertyValue);
        }
    }

    private static boolean isCustomKerberosLoginFound() {
        return StandardKafkaPropertyProvider.isClassFound(SASL_GSSAPI_CUSTOM_LOGIN_CLASS);
    }

    public static boolean isAwsMskIamCallbackHandlerFound() {
        return StandardKafkaPropertyProvider.isClassFound(SASL_AWS_MSK_IAM_CLIENT_CALLBACK_HANDLER_CLASS);
    }

    private static boolean isClassFound(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

