/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.property.provider;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.shared.property.provider.KafkaPropertyNameProvider;

public class StandardKafkaPropertyNameProvider
implements KafkaPropertyNameProvider {
    private static final String COMMON_CLIENT_CONFIGS_CLASS = "org.apache.kafka.clients.CommonClientConfigs";
    private static final String SASL_CONFIGS_CLASS = "org.apache.kafka.common.config.SaslConfigs";
    private static final String SSL_CONFIGS_CLASS = "org.apache.kafka.common.config.SslConfigs";
    private static final String[] PROPERTY_CLASSES = new String[]{"org.apache.kafka.clients.CommonClientConfigs", "org.apache.kafka.common.config.SaslConfigs", "org.apache.kafka.common.config.SslConfigs"};
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^\\S+$");
    private final Set<String> propertyNames;

    public StandardKafkaPropertyNameProvider(Class<?> kafkaClientClass) {
        Set<String> kafkaClientPropertyNames = StandardKafkaPropertyNameProvider.getStaticStringPropertyNames(kafkaClientClass);
        kafkaClientPropertyNames.addAll(StandardKafkaPropertyNameProvider.getCommonPropertyNames());
        this.propertyNames = kafkaClientPropertyNames;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    private static Set<String> getCommonPropertyNames() {
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        for (String propertyClassName : PROPERTY_CLASSES) {
            Optional<Class<?>> propertyClassFound = StandardKafkaPropertyNameProvider.findClass(propertyClassName);
            if (!propertyClassFound.isPresent()) continue;
            Class<?> propertyClass = propertyClassFound.get();
            Set<String> classPropertyNames = StandardKafkaPropertyNameProvider.getStaticStringPropertyNames(propertyClass);
            propertyNames.addAll(classPropertyNames);
        }
        return propertyNames;
    }

    private static Set<String> getStaticStringPropertyNames(Class<?> propertyClass) {
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        for (Field field : propertyClass.getDeclaredFields()) {
            String fieldValue;
            Matcher propertyMatcher;
            int modifiers = field.getModifiers();
            Class<?> fieldType = field.getType();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !String.class.equals(fieldType) || !(propertyMatcher = PROPERTY_PATTERN.matcher(fieldValue = StandardKafkaPropertyNameProvider.getStaticFieldValue(field))).matches()) continue;
            propertyNames.add(fieldValue);
        }
        return propertyNames;
    }

    private static String getStaticFieldValue(Field field) {
        try {
            return String.valueOf(field.get(null));
        }
        catch (Exception e) {
            String message = String.format("Unable to read Kafka Configuration class field [%s]", field.getName());
            throw new IllegalArgumentException(message, e);
        }
    }

    private static Optional<Class<?>> findClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

