/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import javax.security.auth.login.AppConfigurationEntry;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.LoginConfigBuilder;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;
import org.apache.nifi.util.StringUtils;

public class AwsMskIamLoginConfigProvider
implements LoginConfigProvider {
    private static final String MODULE_CLASS = "software.amazon.msk.auth.iam.IAMLoginModule";
    private static final String AWS_PROFILE_NAME_KEY = "awsProfileName";

    @Override
    public String getConfiguration(PropertyContext context) {
        String awsProfileName = context.getProperty(KafkaClientComponent.AWS_PROFILE_NAME).evaluateAttributeExpressions().getValue();
        LoginConfigBuilder builder = new LoginConfigBuilder(MODULE_CLASS, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED);
        if (StringUtils.isNotBlank((String)awsProfileName)) {
            builder.append(AWS_PROFILE_NAME_KEY, awsProfileName);
        }
        return builder.build();
    }
}

