/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.wrapper;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.kafka.service.api.header.RecordHeader;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class WrapperRecord
extends MapRecord {
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String OFFSET = "offset";
    public static final String TIMESTAMP = "timestamp";
    public static final String METADATA = "metadata";
    public static final String HEADERS = "headers";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private static final RecordField FIELD_TOPIC = new RecordField("topic", RecordFieldType.STRING.getDataType());
    private static final RecordField FIELD_PARTITION = new RecordField("partition", RecordFieldType.INT.getDataType());
    private static final RecordField FIELD_OFFSET = new RecordField("offset", RecordFieldType.LONG.getDataType());
    private static final RecordField FIELD_TIMESTAMP = new RecordField("timestamp", RecordFieldType.TIMESTAMP.getDataType());
    public static final RecordSchema SCHEMA_METADATA = new SimpleRecordSchema(Arrays.asList(FIELD_TOPIC, FIELD_PARTITION, FIELD_OFFSET, FIELD_TIMESTAMP));
    public static final RecordField FIELD_METADATA = new RecordField("metadata", RecordFieldType.RECORD.getRecordDataType(SCHEMA_METADATA));
    public static final RecordField FIELD_HEADERS = new RecordField("headers", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));

    private static RecordSchema toRecordSchema(Record record, String messageKeyField) {
        Record recordKey = (Record)record.getValue(messageKeyField);
        RecordSchema recordSchemaKey = recordKey == null ? null : recordKey.getSchema();
        RecordField fieldKey = new RecordField(KEY, RecordFieldType.RECORD.getRecordDataType(recordSchemaKey));
        RecordField fieldValue = new RecordField(VALUE, RecordFieldType.RECORD.getRecordDataType(record.getSchema()));
        return new SimpleRecordSchema(Arrays.asList(FIELD_METADATA, FIELD_HEADERS, fieldKey, fieldValue));
    }

    private static Map<String, Object> toValues(Record record, List<RecordHeader> headers, Charset headerCharset, String messageKeyField, String topic, int partition, long offset, long timestamp) {
        HashMap<String, Object> valuesMetadata = new HashMap<String, Object>();
        valuesMetadata.put(TOPIC, topic);
        valuesMetadata.put(PARTITION, partition);
        valuesMetadata.put(OFFSET, offset);
        valuesMetadata.put(TIMESTAMP, timestamp);
        MapRecord recordMetadata = new MapRecord(SCHEMA_METADATA, valuesMetadata);
        HashMap<String, String> valuesHeaders = new HashMap<String, String>();
        for (RecordHeader header : headers) {
            valuesHeaders.put(header.key(), new String(header.value(), headerCharset));
        }
        HashMap<String, Object> valuesWrapper = new HashMap<String, Object>();
        valuesWrapper.put(METADATA, recordMetadata);
        valuesWrapper.put(HEADERS, valuesHeaders);
        valuesWrapper.put(KEY, record.getValue(messageKeyField));
        valuesWrapper.put(VALUE, record);
        return valuesWrapper;
    }

    public WrapperRecord(Record record, String messageKeyField, List<RecordHeader> headers, Charset headerCharset, String topic, int partition, long offset, long timestamp) {
        super(WrapperRecord.toRecordSchema(record, messageKeyField), WrapperRecord.toValues(record, headers, headerCharset, messageKeyField, topic, partition, offset, timestamp));
    }

    public static RecordSchema toWrapperSchema(RecordField fieldKey, RecordSchema recordSchema) {
        RecordField fieldValue = new RecordField(VALUE, RecordFieldType.RECORD.getRecordDataType(recordSchema));
        return fieldKey == null ? new SimpleRecordSchema(Arrays.asList(FIELD_METADATA, FIELD_HEADERS, fieldValue)) : new SimpleRecordSchema(Arrays.asList(FIELD_METADATA, FIELD_HEADERS, fieldKey, fieldValue));
    }
}

