/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.wrapper;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.kafka.service.api.header.RecordHeader;
import org.apache.nifi.kafka.service.api.record.ByteRecord;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.Tuple;

public class InjectMetadataRecord
extends MapRecord {
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String OFFSET = "offset";
    public static final String TIMESTAMP = "timestamp";
    public static final String METADATA = "kafkaMetadata";
    public static final String HEADERS = "headers";
    public static final String KEY = "key";
    private static final RecordField FIELD_TOPIC = new RecordField("topic", RecordFieldType.STRING.getDataType());
    private static final RecordField FIELD_PARTITION = new RecordField("partition", RecordFieldType.INT.getDataType());
    private static final RecordField FIELD_OFFSET = new RecordField("offset", RecordFieldType.LONG.getDataType());
    private static final RecordField FIELD_TIMESTAMP = new RecordField("timestamp", RecordFieldType.TIMESTAMP.getDataType());
    private static final RecordField FIELD_HEADERS = new RecordField("headers", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));

    private static RecordSchema toRecordSchema(Record record, String messageKeyField) {
        Record recordKey = (Record)record.getValue(messageKeyField);
        RecordSchema recordSchemaKey = recordKey == null ? null : recordKey.getSchema();
        RecordField fieldKey = new RecordField(KEY, RecordFieldType.RECORD.getRecordDataType(recordSchemaKey));
        SimpleRecordSchema metadataRecordSchema = new SimpleRecordSchema(List.of(FIELD_TOPIC, FIELD_PARTITION, FIELD_OFFSET, FIELD_TIMESTAMP, fieldKey, FIELD_HEADERS));
        RecordField metadataField = new RecordField(METADATA, RecordFieldType.RECORD.getRecordDataType((RecordSchema)metadataRecordSchema));
        RecordSchema valueSchema = record.getSchema();
        List valueFields = valueSchema.getFields();
        valueFields.add(metadataField);
        return new SimpleRecordSchema(valueFields);
    }

    private static Map<String, Object> toValues(Record record, List<RecordHeader> headers, Charset headerCharset, String messageKeyField, String topic, int partition, long offset, long timestamp) {
        HashMap<String, Object> valuesMetadata = new HashMap<String, Object>();
        valuesMetadata.put(TOPIC, topic);
        valuesMetadata.put(PARTITION, partition);
        valuesMetadata.put(OFFSET, offset);
        valuesMetadata.put(TIMESTAMP, timestamp);
        valuesMetadata.put(KEY, record.getValue(messageKeyField));
        HashMap<String, String> valuesHeaders = new HashMap<String, String>();
        for (RecordHeader header : headers) {
            valuesHeaders.put(header.key(), new String(header.value(), headerCharset));
        }
        valuesMetadata.put(HEADERS, valuesHeaders);
        Map valueMap = record.toMap();
        valueMap.put(METADATA, valuesMetadata);
        return valueMap;
    }

    public InjectMetadataRecord(Record record, String messageKeyField, List<RecordHeader> headers, Charset headerCharset, String topic, int partition, long offset, long timestamp) {
        super(InjectMetadataRecord.toRecordSchema(record, messageKeyField), InjectMetadataRecord.toValues(record, headers, headerCharset, messageKeyField, topic, partition, offset, timestamp));
    }

    public static RecordSchema toWrapperSchema(RecordField fieldKey, RecordSchema recordSchema) {
        SimpleRecordSchema metadataRecordSchema = fieldKey == null ? new SimpleRecordSchema(List.of(FIELD_TOPIC, FIELD_PARTITION, FIELD_OFFSET, FIELD_TIMESTAMP, FIELD_HEADERS)) : new SimpleRecordSchema(List.of(FIELD_TOPIC, FIELD_PARTITION, FIELD_OFFSET, FIELD_TIMESTAMP, fieldKey, FIELD_HEADERS));
        RecordField metadataField = new RecordField(METADATA, RecordFieldType.RECORD.getRecordDataType((RecordSchema)metadataRecordSchema));
        List valueFields = recordSchema.getFields();
        ArrayList<RecordField> valueFieldsWithInjectedMetadata = new ArrayList<RecordField>(valueFields);
        valueFieldsWithInjectedMetadata.add(metadataField);
        return new SimpleRecordSchema(valueFieldsWithInjectedMetadata);
    }

    public static MapRecord toWrapperRecord(Charset headerCharacterSet, ByteRecord consumerRecord, Record record, Tuple<RecordField, Object> tupleKey) {
        RecordSchema schema = record.getSchema();
        RecordSchema finalSchema = InjectMetadataRecord.toWrapperSchema((RecordField)tupleKey.getKey(), schema);
        HashMap<String, Object> valuesMetadata = new HashMap<String, Object>();
        valuesMetadata.put(TOPIC, consumerRecord.getTopic());
        valuesMetadata.put(PARTITION, consumerRecord.getPartition());
        valuesMetadata.put(OFFSET, consumerRecord.getOffset());
        valuesMetadata.put(TIMESTAMP, consumerRecord.getTimestamp());
        if (tupleKey.getKey() != null) {
            valuesMetadata.put(KEY, tupleKey.getValue());
        }
        HashMap<String, String> valuesHeaders = new HashMap<String, String>();
        for (RecordHeader header : consumerRecord.getHeaders()) {
            valuesHeaders.put(header.key(), new String(header.value(), headerCharacterSet));
        }
        valuesMetadata.put(HEADERS, valuesHeaders);
        Map valueMap = record.toMap();
        HashMap<String, HashMap<String, Object>> valueMapWithInjectedMetadata = new HashMap<String, HashMap<String, Object>>(valueMap);
        valueMapWithInjectedMetadata.put(METADATA, valuesMetadata);
        return new MapRecord(finalSchema, valueMapWithInjectedMetadata);
    }
}

