/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.key;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.kafka.processors.producer.key.KeyFactory;
import org.apache.nifi.serialization.record.Record;

public class AttributeKeyFactory
implements KeyFactory {
    private final FlowFile flowFile;
    private final PropertyValue keyAttribute;
    private final String keyAttributeEncoding;

    public AttributeKeyFactory(FlowFile flowFile, PropertyValue keyAttribute, String keyAttributeEncoding) {
        this.flowFile = flowFile;
        this.keyAttribute = keyAttribute;
        this.keyAttributeEncoding = Optional.ofNullable(keyAttributeEncoding).orElse(StandardCharsets.UTF_8.name());
    }

    @Override
    public byte[] getKey(Map<String, String> attributes, Record record) throws UnsupportedEncodingException {
        String keyAttributeValue = this.keyAttribute.isSet() ? this.keyAttribute.evaluateAttributeExpressions(this.flowFile).getValue() : attributes.get("kafka.key");
        return keyAttributeValue == null ? null : keyAttributeValue.getBytes(this.keyAttributeEncoding);
    }
}

