/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer.convert;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.processors.consumer.OffsetTracker;
import org.apache.nifi.kafka.processors.consumer.convert.AbstractRecordStreamKafkaMessageConverter;
import org.apache.nifi.kafka.processors.consumer.wrapper.ConsumeWrapperRecord;
import org.apache.nifi.kafka.processors.consumer.wrapper.WrapperRecordKeyReader;
import org.apache.nifi.kafka.processors.producer.wrapper.InjectMetadataRecord;
import org.apache.nifi.kafka.processors.producer.wrapper.WrapperRecord;
import org.apache.nifi.kafka.service.api.record.ByteRecord;
import org.apache.nifi.kafka.shared.property.KeyEncoding;
import org.apache.nifi.kafka.shared.property.KeyFormat;
import org.apache.nifi.kafka.shared.property.OutputStrategy;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.Tuple;

public class WrapperRecordStreamKafkaMessageConverter
extends AbstractRecordStreamKafkaMessageConverter {
    private final RecordReaderFactory keyReaderFactory;
    private final KeyFormat keyFormat;
    private final OutputStrategy outputStrategy;

    public WrapperRecordStreamKafkaMessageConverter(RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, RecordReaderFactory keyReaderFactory, Charset headerEncoding, Pattern headerNamePattern, KeyFormat keyFormat, KeyEncoding keyEncoding, boolean commitOffsets, OffsetTracker offsetTracker, ComponentLog logger, String brokerUri, OutputStrategy outputStrategy) {
        super(readerFactory, writerFactory, headerEncoding, headerNamePattern, keyEncoding, commitOffsets, offsetTracker, logger, brokerUri);
        this.keyReaderFactory = keyReaderFactory;
        this.keyFormat = keyFormat;
        this.outputStrategy = outputStrategy;
    }

    @Override
    protected RecordSchema getWriteSchema(RecordSchema inputSchema, ByteRecord consumerRecord, Map<String, String> attributes) throws IOException {
        try {
            WrapperRecordKeyReader keyReader = new WrapperRecordKeyReader(this.keyFormat, this.keyReaderFactory, this.keyEncoding, this.logger);
            Tuple<RecordField, Object> recordKey = keyReader.toWrapperRecordKey(consumerRecord.getKey().orElse(null), attributes);
            RecordSchema fullSchema = this.outputStrategy == OutputStrategy.USE_WRAPPER ? WrapperRecord.toWrapperSchema((RecordField)recordKey.getKey(), inputSchema) : InjectMetadataRecord.toWrapperSchema((RecordField)recordKey.getKey(), inputSchema);
            return this.writerFactory.getSchema(attributes, fullSchema);
        }
        catch (IOException | SchemaNotFoundException | MalformedRecordException e) {
            throw new IOException("Unable to get schema for wrapper record", e);
        }
    }

    @Override
    protected Record convertRecord(ByteRecord consumerRecord, Record record, Map<String, String> attributes) throws IOException {
        try {
            WrapperRecordKeyReader keyReader = new WrapperRecordKeyReader(this.keyFormat, this.keyReaderFactory, this.keyEncoding, this.logger);
            Tuple<RecordField, Object> recordKey = keyReader.toWrapperRecordKey(consumerRecord.getKey().orElse(null), attributes);
            return this.outputStrategy == OutputStrategy.USE_WRAPPER ? new ConsumeWrapperRecord(this.headerEncoding).toWrapperRecord(consumerRecord, record, recordKey) : InjectMetadataRecord.toWrapperRecord(this.headerEncoding, consumerRecord, record, recordKey);
        }
        catch (IOException | SchemaNotFoundException | MalformedRecordException e) {
            throw new IOException("Unable to convert record", e);
        }
    }
}

