/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer.convert;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.processors.consumer.OffsetTracker;
import org.apache.nifi.kafka.processors.consumer.convert.AbstractRecordStreamKafkaMessageConverter;
import org.apache.nifi.kafka.service.api.header.RecordHeader;
import org.apache.nifi.kafka.service.api.record.ByteRecord;
import org.apache.nifi.kafka.shared.property.KeyEncoding;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

public class RecordStreamKafkaMessageConverter
extends AbstractRecordStreamKafkaMessageConverter {
    public RecordStreamKafkaMessageConverter(RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, Charset headerEncoding, Pattern headerNamePattern, KeyEncoding keyEncoding, boolean commitOffsets, OffsetTracker offsetTracker, ComponentLog logger, String brokerUri) {
        super(readerFactory, writerFactory, headerEncoding, headerNamePattern, keyEncoding, commitOffsets, offsetTracker, logger, brokerUri);
    }

    @Override
    protected RecordSchema getWriteSchema(RecordSchema inputSchema, ByteRecord consumerRecord, Map<String, String> attributes) throws IOException {
        try {
            return this.writerFactory.getSchema(attributes, inputSchema);
        }
        catch (IOException | SchemaNotFoundException e) {
            throw new IOException("Unable to get schema for wrapper record", e);
        }
    }

    @Override
    protected Record convertRecord(ByteRecord consumerRecord, Record record, Map<String, String> attributes) {
        return record;
    }

    @Override
    protected Map<String, String> extractHeaders(ByteRecord consumerRecord) {
        if (this.headerNamePattern == null || consumerRecord == null) {
            return Map.of();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (RecordHeader h : consumerRecord.getHeaders()) {
            String name = h.key();
            if (!this.headerNamePattern.matcher(name).matches()) continue;
            headers.put(name, new String(h.value(), this.headerEncoding));
        }
        return headers;
    }
}

