/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer.convert;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.processors.consumer.OffsetTracker;
import org.apache.nifi.kafka.processors.consumer.convert.AbstractRecordStreamKafkaMessageConverter;
import org.apache.nifi.kafka.service.api.record.ByteRecord;
import org.apache.nifi.kafka.shared.property.KeyEncoding;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class InjectOffsetRecordStreamKafkaMessageConverter
extends AbstractRecordStreamKafkaMessageConverter {
    private static final String KAFKA_OFFSET = "kafkaOffset";
    private static final RecordField KAFKA_OFFSET_FIELD = new RecordField("kafkaOffset", RecordFieldType.LONG.getDataType());

    public InjectOffsetRecordStreamKafkaMessageConverter(RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, Charset headerEncoding, Pattern headerNamePattern, KeyEncoding keyEncoding, boolean commitOffsets, OffsetTracker offsetTracker, ComponentLog logger, String brokerUri) {
        super(readerFactory, writerFactory, headerEncoding, headerNamePattern, keyEncoding, commitOffsets, offsetTracker, logger, brokerUri);
    }

    @Override
    protected RecordSchema getWriteSchema(RecordSchema inputSchema, ByteRecord consumerRecord, Map<String, String> attributes) {
        return this.getConvertedRecordSchema(inputSchema);
    }

    @Override
    protected Record convertRecord(ByteRecord consumerRecord, Record record, Map<String, String> attributes) {
        HashMap<String, Long> values = new HashMap<String, Long>(record.toMap());
        long offset = consumerRecord.getOffset();
        values.put(KAFKA_OFFSET, offset);
        RecordSchema convertedRecordSchema = this.getConvertedRecordSchema(record.getSchema());
        return new MapRecord(convertedRecordSchema, values);
    }

    private RecordSchema getConvertedRecordSchema(RecordSchema inputRecordSchema) {
        ArrayList<RecordField> schemaFields = new ArrayList<RecordField>(inputRecordSchema.getFields());
        schemaFields.add(KAFKA_OFFSET_FIELD);
        return new SimpleRecordSchema(schemaFields);
    }
}

