/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer.bundle;

import java.io.ByteArrayOutputStream;

public class BundleValue {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private final long firstOffset;
    private long lastOffset;
    private long count;

    public BundleValue(long offset) {
        this.firstOffset = offset;
        this.lastOffset = offset;
        this.count = 0L;
    }

    public void update(byte[] demarcator, byte[] data, long offset) {
        if (this.bos.size() > 0) {
            this.bos.writeBytes(demarcator);
        }
        this.bos.writeBytes(data);
        this.lastOffset = offset;
        ++this.count;
    }

    public long getFirstOffset() {
        return this.firstOffset;
    }

    public long getLastOffset() {
        return this.lastOffset;
    }

    public long getCount() {
        return this.count;
    }

    public byte[] getData() {
        return this.bos.toByteArray();
    }
}

