/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.service.api.common.OffsetSummary;
import org.apache.nifi.kafka.service.api.common.TopicPartitionSummary;
import org.apache.nifi.kafka.service.api.consumer.PollingContext;
import org.apache.nifi.kafka.service.api.consumer.PollingSummary;
import org.apache.nifi.kafka.service.api.record.ByteRecord;

public class OffsetTracker {
    private final Map<TopicPartitionSummary, OffsetSummary> offsets = new HashMap<TopicPartitionSummary, OffsetSummary>();
    private final Map<String, Long> recordCounts = new HashMap<String, Long>();
    private final AtomicLong totalRecordSize = new AtomicLong();

    public void update(ByteRecord consumerRecord) {
        TopicPartitionSummary topicPartitionSummary = new TopicPartitionSummary(consumerRecord.getTopic(), consumerRecord.getPartition());
        long offset = consumerRecord.getOffset();
        OffsetSummary offsetSummary = this.offsets.computeIfAbsent(topicPartitionSummary, summary -> new OffsetSummary(offset));
        offsetSummary.setOffset(offset);
        this.recordCounts.merge(consumerRecord.getTopic(), consumerRecord.getBundledCount(), Long::sum);
        consumerRecord.getKey().map(key -> ((byte[])key).length).ifPresent(this.totalRecordSize::addAndGet);
        this.totalRecordSize.addAndGet(consumerRecord.getValue().length);
    }

    public long getTotalRecordSize() {
        return this.totalRecordSize.get();
    }

    public Map<String, Long> getRecordCounts() {
        return this.recordCounts;
    }

    public PollingSummary getPollingSummary(PollingContext pollingContext) {
        PollingSummary pollingSummary = pollingContext.getTopicPattern().isPresent() ? new PollingSummary(pollingContext.getGroupId(), (Pattern)pollingContext.getTopicPattern().get(), pollingContext.getAutoOffsetReset(), this.offsets) : new PollingSummary(pollingContext.getGroupId(), pollingContext.getTopics(), pollingContext.getAutoOffsetReset(), this.offsets);
        return pollingSummary;
    }
}

