/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.kafka.service.api.header.RecordHeader;
import org.apache.nifi.kafka.service.api.record.ByteRecord;
import org.apache.nifi.kafka.shared.property.KeyEncoding;

public class KafkaUtils {
    public static Collection<String> toTopicList(String topics) {
        ArrayList<String> topicList = new ArrayList<String>();
        for (String topic : topics.split(",", 100)) {
            String trimmedName = topic.trim();
            if (trimmedName.isEmpty()) continue;
            topicList.add(trimmedName);
        }
        return topicList;
    }

    public static List<RecordHeader> toHeadersFiltered(ByteRecord consumerRecord, Pattern headerNamePattern) {
        if (headerNamePattern != null) {
            return consumerRecord.getHeaders().stream().filter(h -> headerNamePattern.matcher(h.key()).matches()).collect(Collectors.toList());
        }
        return consumerRecord.getHeaders();
    }

    public static String toKeyString(byte[] key, KeyEncoding keyEncoding) {
        String keyAttributeValue = key == null ? null : (KeyEncoding.HEX.equals((Object)keyEncoding) ? HexFormat.of().formatHex(key) : (KeyEncoding.UTF8.equals((Object)keyEncoding) ? new String(key, StandardCharsets.UTF_8) : null));
        return keyAttributeValue;
    }

    public static Map<String, String> toAttributes(ByteRecord consumerRecord, KeyEncoding keyEncoding, Pattern headerNamePattern, Charset headerEncoding, boolean commitOffsets) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("kafka.topic", consumerRecord.getTopic());
        attributes.put("kafka.partition", Long.toString(consumerRecord.getPartition()));
        attributes.put("kafka.offset", Long.toString(consumerRecord.getOffset()));
        attributes.put("kafka.consumer.offsets.committed", String.valueOf(commitOffsets));
        consumerRecord.getHeaders().stream().filter(h -> h.key().equals("kafka.max.offset")).findFirst().ifPresent(h -> attributes.put("kafka.max.offset", new String(h.value(), headerEncoding)));
        consumerRecord.getHeaders().stream().filter(h -> h.key().equals("kafka.count")).findFirst().ifPresent(h -> attributes.put("kafka.count", new String(h.value(), headerEncoding)));
        attributes.put("kafka.timestamp", Long.toString(consumerRecord.getTimestamp()));
        Optional.ofNullable(KafkaUtils.toKeyString(consumerRecord.getKey().orElse(null), keyEncoding)).ifPresent(keyAttribute -> attributes.put("kafka.key", (String)keyAttribute));
        List headers = consumerRecord.getHeaders();
        attributes.put("kafka.header.count", Integer.toString(headers.size()));
        if (headerNamePattern != null) {
            for (RecordHeader header : headers) {
                String name = header.key();
                if (!headerNamePattern.matcher(name).matches()) continue;
                String value = new String(header.value(), headerEncoding);
                attributes.put(name, value);
            }
        }
        return attributes;
    }
}

