/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.connector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.jetty.configuration.connector.ApplicationLayerProtocol;
import org.apache.nifi.jetty.configuration.connector.StandardServerConnectorFactory;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.server.connector.HostPortValidatorCustomizer;
import org.eclipse.jetty.server.HostHeaderCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class FrameworkServerConnectorFactory
extends StandardServerConnectorFactory {
    private static final int IDLE_TIMEOUT = 60000;
    private static final String CIPHER_SUITE_SEPARATOR_PATTERN = ",\\s*";
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile(".+?:(\\d+)$");
    private static final int PORT_GROUP = 1;
    private final int headerSize;
    private final String includeCipherSuites;
    private final String excludeCipherSuites;
    private final Set<Integer> validPorts;
    private SslContextFactory.Server sslContextFactory;

    public FrameworkServerConnectorFactory(Server server, NiFiProperties properties) {
        super(server, FrameworkServerConnectorFactory.getPort(properties));
        this.includeCipherSuites = properties.getProperty("nifi.web.https.ciphersuites.include");
        this.excludeCipherSuites = properties.getProperty("nifi.web.https.ciphersuites.exclude");
        this.headerSize = DataUnit.parseDataSize((String)properties.getWebMaxHeaderSize(), (DataUnit)DataUnit.B).intValue();
        this.validPorts = FrameworkServerConnectorFactory.getValidPorts(properties);
        if (properties.isHTTPSConfigured()) {
            if (properties.isClientAuthRequiredForRestApi()) {
                this.setNeedClientAuth(true);
            } else {
                this.setWantClientAuth(true);
            }
            this.setApplicationLayerProtocols(properties);
            this.setIncludeSecurityProtocols(TlsPlatform.getPreferredProtocols().toArray(new String[0]));
        }
    }

    protected HttpConfiguration getHttpConfiguration() {
        HttpConfiguration httpConfiguration = super.getHttpConfiguration();
        httpConfiguration.setRequestHeaderSize(this.headerSize);
        httpConfiguration.setResponseHeaderSize(this.headerSize);
        httpConfiguration.setIdleTimeout(60000L);
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new HostHeaderCustomizer());
        HostPortValidatorCustomizer hostPortValidatorCustomizer = new HostPortValidatorCustomizer(this.validPorts);
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)hostPortValidatorCustomizer);
        return httpConfiguration;
    }

    protected SslContextFactory.Server getSslContextFactory() {
        if (this.sslContextFactory == null) {
            String[] cipherSuites;
            this.sslContextFactory = super.getSslContextFactory();
            if (StringUtils.isNotBlank((CharSequence)this.includeCipherSuites)) {
                cipherSuites = this.getCipherSuites(this.includeCipherSuites);
                this.sslContextFactory.setIncludeCipherSuites(cipherSuites);
            }
            if (StringUtils.isNotBlank((CharSequence)this.excludeCipherSuites)) {
                cipherSuites = this.getCipherSuites(this.excludeCipherSuites);
                this.sslContextFactory.setExcludeCipherSuites(cipherSuites);
            }
        }
        return this.sslContextFactory;
    }

    private void setApplicationLayerProtocols(NiFiProperties properties) {
        Set protocols = properties.getWebHttpsApplicationProtocols();
        Set applicationLayerProtocols = Arrays.stream(ApplicationLayerProtocol.values()).filter(applicationLayerProtocol -> protocols.contains(applicationLayerProtocol.getProtocol())).collect(Collectors.toSet());
        this.setApplicationLayerProtocols(applicationLayerProtocols);
    }

    private String[] getCipherSuites(String cipherSuitesProperty) {
        return cipherSuitesProperty.split(CIPHER_SUITE_SEPARATOR_PATTERN);
    }

    private static int getPort(NiFiProperties properties) {
        Integer httpsPort = properties.getSslPort();
        Integer httpPort = properties.getPort();
        if (ObjectUtils.allNull((Object[])new Object[]{httpsPort, httpPort})) {
            throw new IllegalStateException("Invalid port configuration in nifi.properties: Neither nifi.web.https.port nor nifi.web.http.port specified");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{httpsPort, httpPort})) {
            throw new IllegalStateException("Invalid port configuration in nifi.properties: Both nifi.web.https.port and nifi.web.http.port specified");
        }
        return (Integer)ObjectUtils.getIfNull((Object)httpsPort, (Object)httpPort);
    }

    private static Set<Integer> getValidPorts(NiFiProperties properties) {
        HashSet<Integer> validPorts = new HashSet<Integer>();
        int serverPort = FrameworkServerConnectorFactory.getPort(properties);
        validPorts.add(serverPort);
        List allowedHosts = properties.getAllowedHostsAsList();
        for (String allowedHost : allowedHosts) {
            Matcher portMatcher = HOST_PORT_PATTERN.matcher(allowedHost);
            if (!portMatcher.matches()) continue;
            String portGroup = portMatcher.group(1);
            int allowedPort = Integer.parseInt(portGroup);
            validPorts.add(allowedPort);
        }
        return validPorts;
    }
}

