/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.cluster.ClusterDetailsFactory;
import org.apache.nifi.controller.DecommissionTask;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.status.history.StatusHistoryDumpFactory;
import org.apache.nifi.diagnostics.DiagnosticsDump;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.DiagnosticsFactory;
import org.apache.nifi.diagnostics.ThreadDumpTask;
import org.apache.nifi.flow.resource.ExternalResourceDescriptor;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flow.resource.ExternalResourceProviderInitializationContext;
import org.apache.nifi.flow.resource.ExternalResourceProviderService;
import org.apache.nifi.flow.resource.ExternalResourceProviderServiceBuilder;
import org.apache.nifi.flow.resource.PropertyBasedExternalResourceProviderInitializationContext;
import org.apache.nifi.framework.ssl.FrameworkSslContextProvider;
import org.apache.nifi.lifecycle.LifeCycleStartException;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionManagerHolder;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.ExtensionUiLoader;
import org.apache.nifi.nar.NarAutoLoader;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.NarLoaderHolder;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.StandardExtensionDiscoveringManager;
import org.apache.nifi.nar.StandardNarLoader;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.ui.extension.contentviewer.ContentViewer;
import org.apache.nifi.ui.extension.contentviewer.SupportedMimeTypes;
import org.apache.nifi.util.FileUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.ContentAccess;
import org.apache.nifi.web.NiFiWebConfigurationContext;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.server.StandardServerProvider;
import org.apache.nifi.web.server.filter.FilterParameter;
import org.apache.nifi.web.server.filter.LogoutCompleteRedirectFilter;
import org.apache.nifi.web.server.filter.RequestFilterProvider;
import org.apache.nifi.web.server.filter.RestApiRequestFilterProvider;
import org.apache.nifi.web.server.filter.StandardRequestFilterProvider;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ResourceServlet;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JettyServer
implements NiFiServer,
ExtensionUiLoader {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final String CONTAINER_JAR_PATTERN = ".*/jetty-jakarta-servlet-api-[^/]*\\.jar$|.*jakarta.servlet.jsp.jstl-[^/]*\\.jar";
    private static final String CONTEXT_PATH_ALL = "/*";
    private static final String CONTEXT_PATH_NIFI = "/nifi";
    private static final String CONTEXT_PATH_NIFI_API = "/nifi-api";
    private static final Set<String> REQUIRED_CONTEXT_PATHS = Set.of("/nifi", "/nifi-api");
    private static final RequestFilterProvider REQUEST_FILTER_PROVIDER = new StandardRequestFilterProvider();
    private static final RequestFilterProvider REST_API_REQUEST_FILTER_PROVIDER = new RestApiRequestFilterProvider();
    private static final String NAR_PROVIDER_PREFIX = "nifi.nar.library.provider.";
    private static final String NAR_PROVIDER_POLL_INTERVAL_PROPERTY = "nifi.nar.library.poll.interval";
    private static final String NAR_PROVIDER_CONFLICT_RESOLUTION = "nifi.nar.library.conflict.resolution";
    private static final String NAR_PROVIDER_RESTRAIN_PROPERTY = "nifi.nar.library.restrain.startup";
    private static final String NAR_PROVIDER_IMPLEMENTATION_PROPERTY = "implementation";
    private static final String DEFAULT_NAR_PROVIDER_POLL_INTERVAL = "5 min";
    private static final String DEFAULT_NAR_PROVIDER_CONFLICT_RESOLUTION = "IGNORE";
    private static final String NAR_DEPENDENCIES_PATH = "NAR-INF/bundled-dependencies";
    private static final String WAR_EXTENSION = ".war";
    private static final int WEB_APP_MAX_FORM_CONTENT_SIZE = 600000;
    private static final String APPLICATION_PATH = "/nifi";
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String HOST_UNSPECIFIED = "0.0.0.0";
    private static final String SPRING_SECURITY_FILTER_CHAIN = "springSecurityFilterChain";
    private static final Duration EXTENSION_UI_POLL_INTERVAL = Duration.ofSeconds(5L);
    private final DeploymentManager deploymentManager = new DeploymentManager();
    private Server server;
    private NiFiProperties props;
    private SSLContext sslContext;
    private Bundle systemBundle;
    private Set<Bundle> bundles;
    private ExtensionMapping extensionMapping;
    private NarAutoLoader narAutoLoader;
    private ExternalResourceProviderService narProviderService;
    private DiagnosticsFactory diagnosticsFactory;
    private DecommissionTask decommissionTask;
    private StatusHistoryDumpFactory statusHistoryDumpFactory;
    private ClusterDetailsFactory clusterDetailsFactory;
    private WebAppContext webApiContext;
    private Collection<WebAppContext> contentViewerWebContexts;
    private Collection<ContentViewer> contentViewers;
    private UiExtensionMapping componentUiExtensions;
    private Collection<WebAppContext> componentUiExtensionWebContexts;
    private final Map<BundleCoordinate, List<App>> appsByBundleCoordinate = new ConcurrentHashMap<BundleCoordinate, List<App>>();
    private final BlockingQueue<Bundle> extensionUisToLoad = new LinkedBlockingQueue<Bundle>();
    private final ExtensionUiLoadTask extensionUiLoadTask = new ExtensionUiLoadTask(this.extensionUisToLoad, this::processExtensionUiBundle);

    public void init() {
        this.clearWorkingDirectory();
        try {
            FrameworkSslContextProvider sslContextProvider = new FrameworkSslContextProvider(this.props);
            this.sslContext = sslContextProvider.loadSslContext().orElse(null);
            StandardServerProvider serverProvider = new StandardServerProvider(this.sslContext);
            this.server = serverProvider.getServer(this.props);
            Handler serverHandler = this.server.getHandler();
            if (!(serverHandler instanceof Handler.Collection)) {
                throw new IllegalStateException("Server Handler not Handler.Collection: Server Provider configuration failed");
            }
            Handler.Collection serverHandlerCollection = (Handler.Collection)serverHandler;
            ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection(new ContextHandler[0]);
            Handler warHandlers = this.loadInitialWars(this.bundles);
            contextHandlerCollection.addHandler(warHandlers);
            this.deploymentManager.setContexts(contextHandlerCollection);
            this.server.addBean((Object)this.deploymentManager);
            serverHandlerCollection.addHandler((Handler)contextHandlerCollection);
        }
        catch (Throwable e) {
            this.startUpFailure(e);
        }
    }

    private void clearWorkingDirectory() {
        File webWorkingDir = this.props.getWebWorkingDirectory();
        try {
            FileUtils.deleteFilesInDirectory((File)webWorkingDir, null, (Logger)logger, (boolean)true, (boolean)true);
        }
        catch (IOException e) {
            logger.warn("Clear Working Directory failed [{}]", (Object)webWorkingDir, (Object)e);
        }
        FileUtils.deleteFile((File)webWorkingDir, (Logger)logger, (int)3);
    }

    private Handler loadInitialWars(Set<Bundle> bundles) {
        Map<File, Bundle> warToBundleLookup = this.findWars(bundles);
        File webUiWar = null;
        File webApiWar = null;
        HashMap<File, Bundle> otherWars = new HashMap<File, Bundle>();
        for (Map.Entry<File, Bundle> warBundleEntry : warToBundleLookup.entrySet()) {
            File war = warBundleEntry.getKey();
            Bundle warBundle = warBundleEntry.getValue();
            if (war.getName().toLowerCase().startsWith("nifi-web-api")) {
                webApiWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-ui")) {
                webUiWar = war;
                continue;
            }
            otherWars.put(war, warBundle);
        }
        if (webUiWar == null) {
            throw new RuntimeException("Unable to load nifi-web WAR");
        }
        if (webApiWar == null) {
            throw new RuntimeException("Unable to load nifi-web-api WAR");
        }
        ExtensionUiInfo extensionUiInfo = this.loadWars(otherWars);
        this.componentUiExtensionWebContexts = new ArrayList<WebAppContext>(extensionUiInfo.componentUiExtensionWebContexts());
        this.contentViewerWebContexts = new ArrayList<WebAppContext>(extensionUiInfo.contentViewerWebContexts());
        this.contentViewers = new HashSet<ContentViewer>(extensionUiInfo.contentViewers());
        this.componentUiExtensions = new UiExtensionMapping(extensionUiInfo.componentUiExtensionsByType());
        ContextHandlerCollection webAppContextHandlers = new ContextHandlerCollection(new ContextHandler[0]);
        Collection<WebAppContext> extensionUiContexts = extensionUiInfo.webAppContexts();
        extensionUiContexts.forEach(arg_0 -> ((ContextHandlerCollection)webAppContextHandlers).addHandler(arg_0));
        ClassLoader frameworkClassLoader = this.getClass().getClassLoader();
        WebAppContext webUiContext = this.loadWar(webUiWar, "/nifi", frameworkClassLoader);
        RewriteHandler uiErrorHandler = new RewriteHandler();
        uiErrorHandler.setServer(this.server);
        RedirectPatternRule redirectToUi = new RedirectPatternRule(CONTEXT_PATH_ALL, "/nifi/#/404");
        uiErrorHandler.addRule((Rule)redirectToUi);
        webUiContext.setErrorHandler((Request.Handler)uiErrorHandler);
        this.webApiContext = this.loadWar(webApiWar, CONTEXT_PATH_NIFI_API, frameworkClassLoader);
        webAppContextHandlers.addHandler((Handler)this.webApiContext);
        this.addDocsServlets(this.webApiContext);
        webAppContextHandlers.addHandler((Handler)webUiContext);
        return webAppContextHandlers;
    }

    public synchronized void loadExtensionUis(Collection<Bundle> bundles) {
        this.extensionUisToLoad.addAll(bundles);
    }

    private void processExtensionUiBundle(Bundle bundle) {
        Map<File, Bundle> warToBundleLookup = this.findWars(Set.of(bundle));
        ExtensionUiInfo extensionUiInfo = this.loadWars(warToBundleLookup);
        Map<BundleCoordinate, List<WebAppContext>> webappContextsByBundleCoordinate = extensionUiInfo.webAppContextsByBundleCoordinate();
        Collection<WebAppContext> webAppContexts = extensionUiInfo.webAppContexts();
        if (webAppContexts.isEmpty()) {
            logger.debug("Extension User Interface Web Applications not found");
            return;
        }
        for (Map.Entry<BundleCoordinate, List<WebAppContext>> entry : webappContextsByBundleCoordinate.entrySet()) {
            for (WebAppContext webAppContext : entry.getValue()) {
                Path warPath = Paths.get(webAppContext.getWar(), new String[0]);
                ExtensionUiApp extensionUiApp = new ExtensionUiApp(this.deploymentManager, null, warPath, webAppContext);
                this.deploymentManager.addApp((App)extensionUiApp);
                List bundleApps = this.appsByBundleCoordinate.computeIfAbsent(entry.getKey(), k -> new ArrayList());
                bundleApps.add(extensionUiApp);
            }
        }
        Collection<WebAppContext> componentUiExtensionWebContexts = extensionUiInfo.componentUiExtensionWebContexts();
        Collection<WebAppContext> contentViewerWebContexts = extensionUiInfo.contentViewerWebContexts();
        ServletContext webApiServletContext = this.webApiContext.getServletHandler().getServletContext();
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webApiServletContext);
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)webApplicationContext.getBean("nifiWebConfigurationContext", NiFiWebConfigurationContext.class);
        FilterHolder securityFilter = this.webApiContext.getServletHandler().getFilter(SPRING_SECURITY_FILTER_CHAIN);
        this.performInjectionForComponentUis(componentUiExtensionWebContexts, configurationContext, securityFilter);
        this.performInjectionForContentViewerUis(contentViewerWebContexts, webApplicationContext, securityFilter);
        this.componentUiExtensionWebContexts.addAll(componentUiExtensionWebContexts);
        this.contentViewerWebContexts.addAll(contentViewerWebContexts);
        this.contentViewers.addAll(extensionUiInfo.contentViewers());
        this.componentUiExtensions.addUiExtensions(extensionUiInfo.componentUiExtensionsByType());
        for (WebAppContext webAppContext : webAppContexts) {
            Throwable unavailableException = webAppContext.getUnavailableException();
            if (unavailableException == null) {
                logger.debug("Web Application [{}] loaded", (Object)webAppContext);
                continue;
            }
            logger.error("Web Application [{}] unavailable after initialization", (Object)webAppContext, (Object)unavailableException);
        }
    }

    public synchronized void unloadExtensionUis(Collection<Bundle> bundles) {
        bundles.forEach(this::unloadExtensionUis);
    }

    private void unloadExtensionUis(Bundle bundle) {
        BundleCoordinate bundleCoordinate = bundle.getBundleDetails().getCoordinate();
        List<App> bundleApps = this.appsByBundleCoordinate.remove(bundleCoordinate);
        if (bundleApps == null) {
            logger.info("No Extension UI WARs exist from bundle [{}]", (Object)bundleCoordinate);
            return;
        }
        logger.info("Unloading {} Extension UI WARs from bundle [{}]", (Object)bundleApps.size(), (Object)bundleCoordinate);
        bundleApps.forEach(app -> this.unloadApp(bundleCoordinate, (App)app));
        this.componentUiExtensions.removeUiExtensions(bundleCoordinate.getGroup(), bundleCoordinate.getId(), bundleCoordinate.getVersion());
        this.contentViewers.removeAll(this.contentViewers.stream().filter(contentViewer -> bundle.equals((Object)contentViewer.getBundle())).toList());
    }

    private void unloadApp(BundleCoordinate bundleCoordinate, App app) {
        logger.info("Unloading Extension UI WAR with context path [{}] from bundle [{}]", (Object)app.getContextPath(), (Object)bundleCoordinate);
        try {
            FilterHolder[] webAppFilterHolders;
            WebAppContext webAppContext = (WebAppContext)app.getContextHandler();
            ServletHandler webAppServletHandler = webAppContext.getServletHandler();
            FilterMapping[] webAppFilterMappings = webAppServletHandler.getFilterMappings();
            if (webAppFilterMappings != null) {
                Arrays.stream(webAppFilterMappings).filter(filterMapping -> filterMapping.getFilterName().equals(SPRING_SECURITY_FILTER_CHAIN)).findFirst().ifPresent(arg_0 -> ((ServletHandler)webAppServletHandler).removeFilterMapping(arg_0));
            }
            if ((webAppFilterHolders = webAppServletHandler.getFilters()) != null) {
                Arrays.stream(webAppFilterHolders).filter(filterHolder -> filterHolder.getName().equals(SPRING_SECURITY_FILTER_CHAIN)).findFirst().ifPresent(arg_0 -> ((ServletHandler)webAppServletHandler).removeFilterHolder(arg_0));
            }
            this.deploymentManager.removeApp(app);
            this.contentViewerWebContexts.removeIf(context -> context.getContextPath().equals(app.getContextPath()));
            this.componentUiExtensionWebContexts.removeIf(context -> context.getContextPath().equals(app.getContextPath()));
            File appWarFile = app.getPath().toFile();
            if (appWarFile.exists() && !appWarFile.delete()) {
                logger.warn("Failed to delete WAR file at [{}]", (Object)appWarFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.error("Failed to unload Extension UI WAR with context path [{}] from bundle [{}]", (Object)app.getContextPath(), (Object)bundleCoordinate);
        }
    }

    private ExtensionUiInfo loadWars(Map<File, Bundle> warToBundleLookup) {
        ArrayList<WebAppContext> webAppContexts = new ArrayList<WebAppContext>();
        HashMap<String, String> mimeMappings = new HashMap<String, String>();
        ArrayList<WebAppContext> componentUiExtensionWebContexts = new ArrayList<WebAppContext>();
        ArrayList<WebAppContext> contentViewerWebContexts = new ArrayList<WebAppContext>();
        HashMap<String, List<UiExtension>> componentUiExtensionsByType = new HashMap<String, List<UiExtension>>();
        HashMap<String, ServletContext> contentViewerServletContexts = new HashMap<String, ServletContext>();
        HashMap<BundleCoordinate, List<WebAppContext>> webAppContextsByBundleCoordinate = new HashMap<BundleCoordinate, List<WebAppContext>>();
        ArrayList<ContentViewer> contentViewers = new ArrayList<ContentViewer>();
        if (!warToBundleLookup.isEmpty()) {
            for (Map.Entry<File, Bundle> warBundleEntry : warToBundleLookup.entrySet()) {
                File war = warBundleEntry.getKey();
                Bundle warBundle = warBundleEntry.getValue();
                HashMap<UiExtensionType, List<String>> uiExtensionInWar = new HashMap<UiExtensionType, List<String>>();
                this.identifyUiExtensionsForComponents(uiExtensionInWar, war);
                if (uiExtensionInWar.isEmpty()) continue;
                String warName = StringUtils.substringBeforeLast((String)war.getName(), (String)".");
                String warContextPath = String.format("/%s", warName);
                ClassLoader narClassLoaderForWar = warBundle.getClassLoader();
                WebAppContext extensionUiContext = this.loadWar(war, warContextPath, narClassLoaderForWar);
                for (Map.Entry entry : uiExtensionInWar.entrySet()) {
                    UiExtensionType extensionType = (UiExtensionType)entry.getKey();
                    List types = (List)entry.getValue();
                    if (UiExtensionType.ContentViewer.equals((Object)extensionType)) {
                        ArrayList<SupportedMimeTypes> supportedMimeTypes = new ArrayList<SupportedMimeTypes>();
                        for (String supportedContentTypes : types) {
                            String[] contentTypeParts;
                            String[] parts = supportedContentTypes.split("=");
                            if (parts.length != 2) continue;
                            String displayName = parts[0];
                            String contentTypes = parts[1];
                            for (String contentType : contentTypeParts = contentTypes.split(",")) {
                                mimeMappings.put(contentType, warContextPath);
                            }
                            supportedMimeTypes.add(new SupportedMimeTypes(displayName, List.of(contentTypeParts)));
                        }
                        contentViewers.add(new ContentViewer(warContextPath, supportedMimeTypes, warBundle));
                        contentViewerWebContexts.add(extensionUiContext);
                        contentViewerServletContexts.put(warContextPath, extensionUiContext.getServletContext());
                        continue;
                    }
                    for (String componentTypeCoordinates : types) {
                        logger.info("Loading UI extension [{}, {}] for {}", new Object[]{extensionType, warContextPath, componentTypeCoordinates});
                        UiExtension uiExtension = new UiExtension(extensionType, warContextPath);
                        List componentUiExtensionsForType = componentUiExtensionsByType.computeIfAbsent(componentTypeCoordinates, k -> new ArrayList());
                        if (this.containsUiExtensionType(componentUiExtensionsForType, extensionType)) {
                            throw new IllegalStateException(String.format("Encountered duplicate UI for %s", componentTypeCoordinates));
                        }
                        componentUiExtensionsForType.add(uiExtension);
                    }
                    componentUiExtensionWebContexts.add(extensionUiContext);
                }
                webAppContexts.add(extensionUiContext);
                BundleCoordinate bundleCoordinate = warBundle.getBundleDetails().getCoordinate();
                List bundleContexts = webAppContextsByBundleCoordinate.computeIfAbsent(bundleCoordinate, k -> new ArrayList());
                bundleContexts.add(extensionUiContext);
            }
        }
        return new ExtensionUiInfo(webAppContexts, mimeMappings, contentViewers, componentUiExtensionWebContexts, contentViewerWebContexts, componentUiExtensionsByType, contentViewerServletContexts, webAppContextsByBundleCoordinate);
    }

    private boolean containsUiExtensionType(List<UiExtension> componentUiExtensionsForType, UiExtensionType extensionType) {
        for (UiExtension uiExtension : componentUiExtensionsForType) {
            if (!extensionType.equals((Object)uiExtension.getExtensionType())) continue;
            return true;
        }
        return false;
    }

    private Map<File, Bundle> findWars(Set<Bundle> bundles) {
        HashMap<File, Bundle> wars = new HashMap<File, Bundle>();
        bundles.forEach(bundle -> {
            BundleDetails details = bundle.getBundleDetails();
            Path bundledDependencies = new File(details.getWorkingDirectory(), NAR_DEPENDENCIES_PATH).toPath();
            if (Files.isDirectory(bundledDependencies, new LinkOption[0])) {
                try (Stream<Path> dependencies = Files.list(bundledDependencies);){
                    dependencies.filter(dependency -> dependency.getFileName().toString().endsWith(WAR_EXTENSION)).map(Path::toFile).forEach(dependency -> wars.put((File)dependency, (Bundle)bundle));
                }
                catch (IOException e) {
                    logger.warn("Failed to find WAR files in bundled-dependencies [{}]", (Object)bundledDependencies, (Object)e);
                }
            }
        });
        return wars;
    }

    private void readUiExtensions(Map<UiExtensionType, List<String>> uiExtensions, UiExtensionType uiExtensionType, JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (jarEntry == null) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));){
            String rawComponentType;
            while ((rawComponentType = in.readLine()) != null) {
                String componentType = this.extractComponentType(rawComponentType);
                if (componentType == null) continue;
                List extensions = uiExtensions.computeIfAbsent(uiExtensionType, k -> new ArrayList());
                extensions.add(componentType);
            }
        }
    }

    private void identifyUiExtensionsForComponents(Map<UiExtensionType, List<String>> uiExtensions, File warFile) {
        try (JarFile jarFile = new JarFile(warFile);){
            this.readUiExtensions(uiExtensions, UiExtensionType.ContentViewer, jarFile, jarFile.getJarEntry("META-INF/nifi-content-viewer"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ProcessorConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-processor-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ControllerServiceConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-controller-service-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ReportingTaskConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-reporting-task-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ParameterProviderConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-parameter-provider-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.FlowRegistryClientConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-flow-registry-client-configuration"));
        }
        catch (IOException ioe) {
            logger.warn("Unable to inspect {} for a UI extensions.", (Object)warFile);
        }
    }

    private String extractComponentType(String line) {
        String trimmedLine = line.trim();
        if (!trimmedLine.isEmpty() && !trimmedLine.startsWith("#")) {
            int indexOfPound = trimmedLine.indexOf("#");
            return indexOfPound > 0 ? trimmedLine.substring(0, indexOfPound) : trimmedLine;
        }
        return null;
    }

    private WebAppContext loadWar(File warFile, String contextPath, ClassLoader parentClassLoader) {
        List<FilterHolder> requestFilters;
        WebAppContext webappContext = new WebAppContext(warFile.getPath(), contextPath);
        webappContext.getInitParams().put(ALLOWED_CONTEXT_PATHS_PARAMETER, this.props.getAllowedContextPaths());
        webappContext.setMaxFormContentSize(600000);
        webappContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)CONTAINER_JAR_PATTERN);
        webappContext.setErrorHandler((Request.Handler)this.getErrorHandler());
        webappContext.setTempDirectory(this.getWebAppTempDirectory(warFile));
        boolean throwUnavailableOnStartupException = REQUIRED_CONTEXT_PATHS.contains(contextPath);
        webappContext.setThrowUnavailableOnStartupException(throwUnavailableOnStartupException);
        List<FilterHolder> list = requestFilters = CONTEXT_PATH_NIFI_API.equals(contextPath) ? REST_API_REQUEST_FILTER_PROVIDER.getFilters(this.props) : REQUEST_FILTER_PROVIDER.getFilters(this.props);
        if ("/nifi".equals(contextPath)) {
            FilterHolder logoutCompleteFilterHolder = new FilterHolder(LogoutCompleteRedirectFilter.class);
            logoutCompleteFilterHolder.setName(LogoutCompleteRedirectFilter.class.getSimpleName());
            requestFilters.add(logoutCompleteFilterHolder);
        }
        requestFilters.forEach(filter -> {
            String pathSpecification = filter.getInitParameter(FilterParameter.PATH_SPECIFICATION.name());
            String filterPathSpecification = pathSpecification == null ? CONTEXT_PATH_ALL : pathSpecification;
            webappContext.addFilter(filter, filterPathSpecification, EnumSet.allOf(DispatcherType.class));
        });
        webappContext.setClassLoader((ClassLoader)new WebAppClassLoader(parentClassLoader, (WebAppClassLoader.Context)webappContext));
        logger.info("Loading WAR [{}] Context Path [{}]", (Object)warFile.getAbsolutePath(), (Object)contextPath);
        return webappContext;
    }

    private File getWebAppTempDirectory(File warFile) {
        File tempDirectory = new File(this.props.getWebWorkingDirectory(), warFile.getName()).getAbsoluteFile();
        if (tempDirectory.exists() && !tempDirectory.isDirectory()) {
            throw new IllegalStateException("Web Application Temporary Directory [%s] is not a directory".formatted(tempDirectory));
        }
        if (!tempDirectory.exists()) {
            boolean created = tempDirectory.mkdirs();
            if (created) {
                logger.debug("Web Application Temporary Directory [{}] created", (Object)tempDirectory);
            } else {
                throw new IllegalStateException("Web Application Temporary Directory [%s] directory creation failed".formatted(tempDirectory));
            }
        }
        if (!tempDirectory.canRead()) {
            throw new IllegalStateException("Web Application Temporary Directory [%s] is missing read permission".formatted(tempDirectory));
        }
        if (!tempDirectory.canWrite()) {
            throw new IllegalStateException("Web Application Temporary Directory [%s] is missing write permissions".formatted(tempDirectory));
        }
        return tempDirectory;
    }

    private void addDocsServlets(WebAppContext webAppContext) {
        try {
            File docsDir = this.getDocsDir();
            ServletHolder docs = new ServletHolder("docs", ResourceServlet.class);
            Path htmlBaseResource = docsDir.toPath().resolve("html");
            docs.setInitParameter("baseResource", htmlBaseResource.toString());
            docs.setInitParameter("dirAllowed", "false");
            webAppContext.addServlet(docs, "/html/*");
            ServletHolder restApi = new ServletHolder("rest-api", ResourceServlet.class);
            File webApiDocsDir = this.getWebApiDocsDir();
            restApi.setInitParameter("baseResource", webApiDocsDir.getPath());
            restApi.setInitParameter("dirAllowed", "false");
            webAppContext.addServlet(restApi, "/rest-api/*");
            logger.info("Loading Docs [{}] Context Path [{}]", (Object)docsDir.getAbsolutePath(), (Object)webAppContext.getContextPath());
        }
        catch (Exception ex) {
            logger.error("Unhandled Exception in createDocsWebApp", (Throwable)ex);
            this.startUpFailure(ex);
        }
    }

    private File getDocsDir() {
        File docsDir;
        block2: {
            String docsDirectory = "docs";
            try {
                docsDir = Paths.get("docs", new String[0]).toRealPath(new LinkOption[0]).toFile();
            }
            catch (IOException ex) {
                logger.info("Directory '{}' is missing. Some documentation will be unavailable.", (Object)"docs");
                docsDir = new File("docs").getAbsoluteFile();
                boolean made = docsDir.mkdirs();
                if (made) break block2;
                logger.error("Failed to create 'docs' directory!");
                this.startUpFailure(new IOException(docsDir.getAbsolutePath() + " could not be created"));
            }
        }
        return docsDir;
    }

    private File getWebApiDocsDir() {
        boolean made;
        File webApiDocsDir = new File(this.webApiContext.getTempDirectory(), "webapp/docs/rest-api");
        if (!webApiDocsDir.exists() && !(made = webApiDocsDir.mkdirs())) {
            logger.error("Failed to create {}", (Object)webApiDocsDir.getAbsolutePath());
            this.startUpFailure(new IOException(webApiDocsDir.getAbsolutePath() + " could not be created"));
        }
        return webApiDocsDir;
    }

    protected List<URI> getApplicationUrls() {
        return Arrays.stream(this.server.getConnectors()).map(connector -> (ServerConnector)connector).map(serverConnector -> {
            SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)serverConnector.getConnectionFactory(SslConnectionFactory.class);
            String scheme = sslConnectionFactory == null ? HTTP_SCHEME : HTTPS_SCHEME;
            int port = serverConnector.getLocalPort();
            String connectorHost = serverConnector.getHost();
            String host = (String)StringUtils.defaultIfEmpty((CharSequence)connectorHost, (CharSequence)HOST_UNSPECIFIED);
            try {
                return new URI(scheme, null, host, port, "/nifi", null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public void start() {
        try {
            List<URI> applicationUrls;
            StandardExtensionDiscoveringManager extensionManager = new StandardExtensionDiscoveringManager();
            extensionManager.discoverExtensions(this.systemBundle, this.bundles);
            extensionManager.logClassLoaderMapping();
            ExtensionManagerHolder.init((ExtensionManager)extensionManager);
            this.narProviderService = new ExternalResourceProviderServiceBuilder("NAR Auto-Loader Provider", (ExtensionManager)extensionManager).providers(this.buildExternalResourceProviders(this.sslContext, (ExtensionManager)extensionManager, descriptor -> descriptor.getLocation().toLowerCase().endsWith(".nar"))).targetDirectory(new File(this.props.getProperty("nifi.nar.library.autoload.directory", "./extensions"))).conflictResolutionStrategy(this.props.getProperty(NAR_PROVIDER_CONFLICT_RESOLUTION, DEFAULT_NAR_PROVIDER_CONFLICT_RESOLUTION)).pollInterval(this.props.getProperty(NAR_PROVIDER_POLL_INTERVAL_PROPERTY, DEFAULT_NAR_PROVIDER_POLL_INTERVAL)).restrainingStartup(Boolean.parseBoolean(this.props.getProperty(NAR_PROVIDER_RESTRAIN_PROPERTY, "true"))).build();
            this.narProviderService.start();
            NarUnpackMode unpackMode = this.props.isUnpackNarsToUberJar() ? NarUnpackMode.UNPACK_TO_UBER_JAR : NarUnpackMode.UNPACK_INDIVIDUAL_JARS;
            StandardNarLoader narLoader = new StandardNarLoader(this.props.getExtensionsWorkingDirectory(), NarClassLoadersHolder.getInstance(), (ExtensionDiscoveringManager)extensionManager, this.extensionMapping, (ExtensionUiLoader)this, unpackMode);
            NarLoaderHolder.init((NarLoader)narLoader);
            this.narAutoLoader = new NarAutoLoader(this.props, (NarLoader)narLoader);
            this.narAutoLoader.start();
            this.server.start();
            if (this.webApiContext != null) {
                ServletContext webApiServletContext = this.webApiContext.getServletHandler().getServletContext();
                webApiServletContext.setAttribute("nifi-ui-extensions", (Object)this.componentUiExtensions);
                WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webApiServletContext);
                NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)webApplicationContext.getBean("nifiWebConfigurationContext", NiFiWebConfigurationContext.class);
                FilterHolder securityFilter = this.webApiContext.getServletHandler().getFilter(SPRING_SECURITY_FILTER_CHAIN);
                this.performInjectionForComponentUis(this.componentUiExtensionWebContexts, configurationContext, securityFilter);
                this.performInjectionForContentViewerUis(this.contentViewerWebContexts, webApplicationContext, securityFilter);
                webApiServletContext.setAttribute("content-viewers", this.contentViewers);
                this.diagnosticsFactory = (DiagnosticsFactory)webApplicationContext.getBean("diagnosticsFactory", DiagnosticsFactory.class);
                this.decommissionTask = (DecommissionTask)webApplicationContext.getBean("decommissionTask", DecommissionTask.class);
                this.statusHistoryDumpFactory = (StatusHistoryDumpFactory)webApplicationContext.getBean("statusHistoryDumpFactory", StatusHistoryDumpFactory.class);
                this.clusterDetailsFactory = (ClusterDetailsFactory)webApplicationContext.getBean("clusterDetailsFactory", ClusterDetailsFactory.class);
            }
            Thread.ofVirtual().name("Extension UI Loader").start(this.extensionUiLoadTask);
            if (this.props.isNode()) {
                FlowService flowService = null;
                try {
                    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.webApiContext.getServletContext());
                    flowService = (FlowService)((ApplicationContext)Objects.requireNonNull(ctx)).getBean("flowService", FlowService.class);
                    flowService.start();
                    flowService.load(null);
                }
                catch (IOException | UninheritableFlowException | FlowSerializationException | FlowSynchronizationException | LifeCycleStartException | BeansException e) {
                    if (flowService != null && flowService.isRunning()) {
                        flowService.stop(false);
                    }
                    logger.error("Failed to start Flow Service", e);
                    throw new Exception("Failed to start Flow Service: " + String.valueOf(e));
                }
            }
            if ((applicationUrls = this.getApplicationUrls()).isEmpty()) {
                logger.warn("Started Server without connectors");
            } else {
                for (URI applicationUrl : applicationUrls) {
                    logger.info("Started Server on {}", (Object)applicationUrl);
                }
            }
        }
        catch (Throwable t) {
            this.startUpFailure(t);
        }
    }

    private Map<String, ExternalResourceProvider> buildExternalResourceProviders(SSLContext sslContext, ExtensionManager extensionManager, Predicate<ExternalResourceDescriptor> filter) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap<String, ExternalResourceProvider> result = new HashMap<String, ExternalResourceProvider>();
        Set externalSourceNames = this.props.getDirectSubsequentTokens(NAR_PROVIDER_PREFIX);
        for (String externalSourceName : externalSourceNames) {
            logger.info("External resource provider '{}' found in configuration", (Object)externalSourceName);
            String providerClass = this.props.getProperty(NAR_PROVIDER_PREFIX + externalSourceName + ".implementation");
            String providerId = UUID.randomUUID().toString();
            PropertyBasedExternalResourceProviderInitializationContext context = new PropertyBasedExternalResourceProviderInitializationContext(sslContext, this.props, NAR_PROVIDER_PREFIX + externalSourceName + ".", filter);
            result.put(providerId, this.createProviderInstance(extensionManager, providerClass, providerId, (ExternalResourceProviderInitializationContext)context));
        }
        return result;
    }

    private ExternalResourceProvider createProviderInstance(ExtensionManager extensionManager, String providerClass, String providerId, ExternalResourceProviderInitializationContext context) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        ExternalResourceProvider provider;
        try {
            provider = (ExternalResourceProvider)NarThreadContextClassLoader.createInstance((ExtensionManager)extensionManager, (String)providerClass, ExternalResourceProvider.class, (NiFiProperties)this.props, (String)providerId);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Class %s does not implement ExternalResourceProvider", providerClass), e);
        }
        provider.initialize(context);
        return provider;
    }

    public DiagnosticsFactory getDiagnosticsFactory() {
        return this.diagnosticsFactory == null ? this.getThreadDumpFactory() : this.diagnosticsFactory;
    }

    public DiagnosticsFactory getThreadDumpFactory() {
        return new ThreadDumpDiagnosticsFactory();
    }

    public DecommissionTask getDecommissionTask() {
        return this.decommissionTask;
    }

    public ClusterDetailsFactory getClusterDetailsFactory() {
        return this.clusterDetailsFactory;
    }

    public StatusHistoryDumpFactory getStatusHistoryDumpFactory() {
        return this.statusHistoryDumpFactory;
    }

    private void performInjectionForComponentUis(Collection<WebAppContext> componentUiExtensionWebContexts, NiFiWebConfigurationContext configurationContext, FilterHolder securityFilter) {
        for (WebAppContext customUiContext : componentUiExtensionWebContexts) {
            ServletContext customUiServletContext = customUiContext.getServletHandler().getServletContext();
            customUiServletContext.setAttribute("nifi-web-configuration-context", (Object)configurationContext);
            if (securityFilter == null) continue;
            customUiContext.addFilter(securityFilter, CONTEXT_PATH_ALL, EnumSet.allOf(DispatcherType.class));
        }
    }

    private void performInjectionForContentViewerUis(Collection<WebAppContext> contentViewerWebContexts, WebApplicationContext webApiApplicationContext, FilterHolder securityFilter) {
        for (WebAppContext contentViewerContext : contentViewerWebContexts) {
            ContentAccess contentAccess = (ContentAccess)webApiApplicationContext.getBean("contentAccess", ContentAccess.class);
            ServletContext webContentViewerServletContext = contentViewerContext.getServletHandler().getServletContext();
            webContentViewerServletContext.setAttribute("nifi-content-access", (Object)contentAccess);
            if (securityFilter == null) continue;
            contentViewerContext.addFilter(securityFilter, CONTEXT_PATH_ALL, EnumSet.allOf(DispatcherType.class));
        }
    }

    private void startUpFailure(Throwable t) {
        logger.error("Failed to start Server", t);
        System.exit(1);
    }

    public void initialize(NiFiProperties properties, Bundle systemBundle, Set<Bundle> bundles, ExtensionMapping extensionMapping) {
        this.props = properties;
        this.systemBundle = systemBundle;
        this.bundles = bundles;
        this.extensionMapping = extensionMapping;
        this.init();
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.warn("Failed to stop Server", (Throwable)e);
        }
        try {
            if (this.narAutoLoader != null) {
                this.narAutoLoader.stop();
            }
        }
        catch (Exception e) {
            logger.warn("Failed to stop NAR auto-loader", (Throwable)e);
        }
        try {
            if (this.narProviderService != null) {
                this.narProviderService.stop();
            }
        }
        catch (Exception e) {
            logger.warn("Failed to stop NAR provider", (Throwable)e);
        }
        this.extensionUiLoadTask.stop();
    }

    private ErrorPageErrorHandler getErrorHandler() {
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.setShowServlet(false);
        errorHandler.setShowStacks(false);
        errorHandler.setShowMessageInTitle(false);
        return errorHandler;
    }

    private static class ExtensionUiLoadTask
    implements Runnable {
        private final BlockingQueue<Bundle> extensionUiBundlesToLoad;
        private final Consumer<Bundle> extensionUiLoadFunction;
        private volatile boolean stopped = false;

        public ExtensionUiLoadTask(BlockingQueue<Bundle> extensionUiBundlesToLoad, Consumer<Bundle> extensionUiLoadFunction) {
            this.extensionUiBundlesToLoad = extensionUiBundlesToLoad;
            this.extensionUiLoadFunction = extensionUiLoadFunction;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    Bundle bundle = this.extensionUiBundlesToLoad.poll(EXTENSION_UI_POLL_INTERVAL.getSeconds(), TimeUnit.SECONDS);
                    if (bundle == null) continue;
                    this.extensionUiLoadFunction.accept(bundle);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    logger.error("Failed to load extension UI", (Throwable)e);
                }
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    private record ExtensionUiInfo(Collection<WebAppContext> webAppContexts, Map<String, String> mimeMappings, Collection<ContentViewer> contentViewers, Collection<WebAppContext> componentUiExtensionWebContexts, Collection<WebAppContext> contentViewerWebContexts, Map<String, List<UiExtension>> componentUiExtensionsByType, Map<String, ServletContext> contentViewerServletContexts, Map<BundleCoordinate, List<WebAppContext>> webAppContextsByBundleCoordinate) {
    }

    private static class ExtensionUiApp
    extends App {
        private final WebAppContext webAppContext;

        public ExtensionUiApp(DeploymentManager manager, AppProvider provider, Path path, WebAppContext webAppContext) {
            super(manager, provider, path);
            this.webAppContext = webAppContext;
        }

        public ContextHandler getContextHandler() {
            return this.webAppContext;
        }

        public String getContextPath() {
            return this.webAppContext.getContextPath();
        }
    }

    private static class ThreadDumpDiagnosticsFactory
    implements DiagnosticsFactory {
        private ThreadDumpDiagnosticsFactory() {
        }

        public DiagnosticsDump create(boolean verbose) {
            return out -> {
                DiagnosticsDumpElement threadDumpElement = new ThreadDumpTask().captureDump(verbose);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                for (String detail : threadDumpElement.getDetails()) {
                    writer.write(detail);
                    writer.write("\n");
                }
                writer.flush();
            };
        }
    }
}

